/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.core;

import android.util.Base64;

public class EciesCryptogram {
    public final byte[] body;
    public final byte[] mac;
    public final byte[] key;
    public final byte[] nonce;

    public String getBodyBase64() {
        if (this.body != null) {
            return Base64.encodeToString((byte[])this.body, (int)2);
        }
        return null;
    }

    public String getMacBase64() {
        if (this.mac != null) {
            return Base64.encodeToString((byte[])this.mac, (int)2);
        }
        return null;
    }

    public String getKeyBase64() {
        if (this.key != null) {
            return Base64.encodeToString((byte[])this.key, (int)2);
        }
        return null;
    }

    public String getNonceBase64() {
        if (this.nonce != null) {
            return Base64.encodeToString((byte[])this.nonce, (int)2);
        }
        return null;
    }

    public EciesCryptogram() {
        this.body = null;
        this.mac = null;
        this.key = null;
        this.nonce = null;
    }

    public EciesCryptogram(byte[] body, byte[] mac, byte[] key, byte[] nonce) {
        this.body = body;
        this.mac = mac;
        this.key = key;
        this.nonce = nonce;
    }

    public EciesCryptogram(String bodyBase64, String macBase64, String keyBase64, String nonceBase64) {
        this.body = bodyBase64 != null ? Base64.decode((String)bodyBase64, (int)2) : null;
        this.mac = macBase64 != null ? Base64.decode((String)macBase64, (int)2) : null;
        this.key = keyBase64 != null ? Base64.decode((String)keyBase64, (int)2) : null;
        this.nonce = nonceBase64 != null ? Base64.decode((String)nonceBase64, (int)2) : null;
    }

    public EciesCryptogram(String bodyBase64, String macBase64) {
        this.body = bodyBase64 != null ? Base64.decode((String)bodyBase64, (int)2) : null;
        this.mac = macBase64 != null ? Base64.decode((String)macBase64, (int)2) : null;
        this.key = null;
        this.nonce = null;
    }
}

