/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk.impl;

import android.os.CancellationSignal;
import android.support.annotation.NonNull;
import io.getlime.security.powerauth.networking.interfaces.ICancelable;

public class CancelableTask
implements ICancelable {
    private boolean isCancelled;
    private final OnCancelListener onCancelListener;
    private CancellationSignal cancellationSignal;

    public CancelableTask(@NonNull OnCancelListener listener) {
        this.onCancelListener = listener;
    }

    public CancelableTask() {
        this.onCancelListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CancellationSignal getCancellationSignal() {
        CancelableTask cancelableTask = this;
        synchronized (cancelableTask) {
            if (this.cancellationSignal == null) {
                this.cancellationSignal = new CancellationSignal();
            }
            return this.cancellationSignal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        OnCancelListener listener;
        CancellationSignal signal;
        CancelableTask cancelableTask = this;
        synchronized (cancelableTask) {
            if (this.isCancelled) {
                return;
            }
            this.isCancelled = true;
            signal = this.cancellationSignal;
            listener = this.onCancelListener;
        }
        if (signal != null) {
            signal.cancel();
        }
        if (listener != null) {
            listener.onCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        CancelableTask cancelableTask = this;
        synchronized (cancelableTask) {
            return this.isCancelled;
        }
    }

    public static interface OnCancelListener {
        public void onCancel();
    }
}

