/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import java.util.Arrays;

public class BiometricAuthenticationRequest {
    @NonNull
    private final CharSequence title;
    @Nullable
    private final CharSequence subtitle;
    @NonNull
    private final CharSequence description;
    private final boolean forceGenerateNewKey;
    private final boolean invalidateByBiometricEnrollment;
    @NonNull
    private final byte[] keyToProtect;

    private BiometricAuthenticationRequest(@NonNull CharSequence title, @Nullable CharSequence subtitle, @NonNull CharSequence description, boolean forceGenerateNewKey, boolean invalidateByBiometricEnrollment, @NonNull byte[] keyToProtect) {
        this.title = title;
        this.subtitle = subtitle;
        this.description = description;
        this.forceGenerateNewKey = forceGenerateNewKey;
        this.invalidateByBiometricEnrollment = invalidateByBiometricEnrollment;
        this.keyToProtect = Arrays.copyOf(keyToProtect, keyToProtect.length);
    }

    @NonNull
    public CharSequence getTitle() {
        return this.title;
    }

    @Nullable
    public CharSequence getSubtitle() {
        return this.subtitle;
    }

    @NonNull
    public CharSequence getDescription() {
        return this.description;
    }

    public boolean isForceGenerateNewKey() {
        return this.forceGenerateNewKey;
    }

    public boolean isInvalidateByBiometricEnrollment() {
        return this.invalidateByBiometricEnrollment;
    }

    @NonNull
    public byte[] getKeyToProtect() {
        return this.keyToProtect;
    }

    public static class Builder {
        @NonNull
        private final Context context;
        private CharSequence title;
        private CharSequence subtitle;
        private CharSequence description;
        private boolean forceGenerateNewKey;
        private boolean invalidateByBiometricEnrollment = true;
        private byte[] keyToProtect;

        public Builder(@NonNull Context context) {
            this.context = context;
        }

        public BiometricAuthenticationRequest build() {
            if (this.title == null || this.description == null) {
                throw new IllegalArgumentException("Title and description is required.");
            }
            if (this.keyToProtect == null) {
                throw new IllegalArgumentException("KeyToProtect is required.");
            }
            if (this.keyToProtect.length < 16) {
                throw new IllegalArgumentException("KeyToProtect length is insufficient.");
            }
            return new BiometricAuthenticationRequest(this.title, this.subtitle, this.description, this.forceGenerateNewKey, this.invalidateByBiometricEnrollment, this.keyToProtect);
        }

        public Builder setTitle(@NonNull CharSequence title) {
            this.title = title;
            return this;
        }

        public Builder setTitle(@StringRes int titleId) {
            return this.setTitle(this.context.getText(titleId));
        }

        public Builder setSubtitle(@NonNull CharSequence subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder setSubtitle(@StringRes int subtitleId) {
            return this.setSubtitle(this.context.getText(subtitleId));
        }

        public Builder setDescription(@NonNull CharSequence description) {
            this.description = description;
            return this;
        }

        public Builder setDescription(@StringRes int descriptionId) {
            return this.setDescription(this.context.getText(descriptionId));
        }

        public Builder setForceGenerateNewKey(boolean forceGenerateNewKey, boolean invalidateByBiometricEnrollment) {
            this.forceGenerateNewKey = forceGenerateNewKey;
            this.invalidateByBiometricEnrollment = invalidateByBiometricEnrollment;
            return this;
        }

        public Builder setKeyToProtect(@NonNull byte[] keyBytes) {
            this.keyToProtect = keyBytes;
            return this;
        }
    }
}

