/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk.impl;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import io.getlime.security.powerauth.networking.interfaces.IExecutorProvider;
import java.util.ArrayDeque;
import java.util.concurrent.Executor;

public class DefaultExecutorProvider
implements IExecutorProvider {
    private Executor serialExecutor;

    @Override
    @NonNull
    public Executor getSerialExecutor() {
        if (this.serialExecutor == null) {
            this.serialExecutor = new SerialExecutor();
        }
        return this.serialExecutor;
    }

    @Override
    @NonNull
    public Executor getConcurrentExecutor() {
        return AsyncTask.THREAD_POOL_EXECUTOR;
    }

    private static class SerialExecutor
    implements Executor {
        final ArrayDeque<Runnable> mTasks = new ArrayDeque();
        Runnable mActive;

        private SerialExecutor() {
        }

        @Override
        public synchronized void execute(final Runnable r) {
            this.mTasks.offer(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.run();
                    }
                    finally {
                        SerialExecutor.this.scheduleNext();
                    }
                }
            });
            if (this.mActive == null) {
                this.scheduleNext();
            }
        }

        protected synchronized void scheduleNext() {
            this.mActive = this.mTasks.poll();
            if (this.mActive != null) {
                AsyncTask.THREAD_POOL_EXECUTOR.execute(this.mActive);
            }
        }
    }
}

