/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl.legacy;

import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Build;
import android.os.CancellationSignal;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.FragmentManager;
import io.getlime.security.powerauth.biometry.BiometricAuthenticationRequest;
import io.getlime.security.powerauth.biometry.IBiometricKeystore;
import io.getlime.security.powerauth.biometry.impl.BiometricHelper;
import io.getlime.security.powerauth.biometry.impl.BiometricResultDispatcher;
import io.getlime.security.powerauth.biometry.impl.IBiometricAuthenticator;
import io.getlime.security.powerauth.biometry.impl.PrivateRequestData;
import io.getlime.security.powerauth.biometry.impl.legacy.FingerprintAuthenticationDialogFragment;
import io.getlime.security.powerauth.biometry.impl.legacy.FingerprintAuthenticationHandler;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.networking.interfaces.ICancelable;
import io.getlime.security.powerauth.sdk.impl.CancelableTask;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

@RequiresApi(api=23)
public class FingerprintAuthenticator
implements IBiometricAuthenticator {
    @NonNull
    private final Context context;
    @NonNull
    private final FingerprintManager fingerprintManager;
    @NonNull
    private final IBiometricKeystore keystore;
    private byte[] alreadyProtectedKey;

    @Nullable
    public static IBiometricAuthenticator createAuthenticator(@NonNull Context context, @NonNull IBiometricKeystore keystore) {
        FingerprintManager fingerprintManager;
        if (!keystore.isKeystoreReady()) {
            return null;
        }
        if (Build.VERSION.SDK_INT == 23) {
            fingerprintManager = (FingerprintManager)context.getSystemService(FingerprintManager.class);
        } else if (Build.VERSION.SDK_INT > 23 && context.getPackageManager().hasSystemFeature("android.hardware.fingerprint")) {
            fingerprintManager = (FingerprintManager)context.getSystemService(FingerprintManager.class);
        } else {
            return null;
        }
        if (fingerprintManager == null) {
            return null;
        }
        if (!fingerprintManager.isHardwareDetected()) {
            return null;
        }
        return new FingerprintAuthenticator(context, keystore, fingerprintManager);
    }

    private FingerprintAuthenticator(@NonNull Context context, @NonNull IBiometricKeystore keystore, @NonNull FingerprintManager manager) {
        this.context = context;
        this.fingerprintManager = manager;
        this.keystore = keystore;
    }

    @Override
    public boolean isAvailable() {
        return this.keystore.isKeystoreReady();
    }

    @Override
    public int canAuthenticate() {
        if (!this.isAvailable()) {
            return 3;
        }
        if (!this.fingerprintManager.hasEnrolledFingerprints()) {
            return 2;
        }
        return 0;
    }

    @Override
    @NonNull
    public IBiometricKeystore getBiometricKeystore() {
        return this.keystore;
    }

    @Override
    @Nullable
    public ICancelable authenticate(@NonNull Context context, @NonNull FragmentManager fragmentManager, @NonNull PrivateRequestData requestData) throws PowerAuthErrorException {
        final BiometricAuthenticationRequest request = requestData.getRequest();
        final BiometricResultDispatcher dispatcher = requestData.getDispatcher();
        FingerprintManager.CryptoObject cryptoObject = this.getCryptoObject(requestData.getSecretKey());
        if (cryptoObject == null) {
            throw new PowerAuthErrorException(18, "Cannot create CryptoObject for biometric authentication.");
        }
        CancellationSignal cancellationSignal = dispatcher.getCancelableTask().getCancellationSignal();
        final FingerprintAuthenticationDialogFragment dialogFragment = new FingerprintAuthenticationDialogFragment.Builder(context).setTitle(request.getTitle()).setDescription(request.getDescription()).setDialogResources(requestData.getResources()).build();
        FingerprintAuthenticationHandler handler = new FingerprintAuthenticationHandler(this.fingerprintManager, cryptoObject, cancellationSignal, dialogFragment, new FingerprintAuthenticationHandler.ResultCallback(){

            @Override
            public void onAuthenticationSuccess(@NonNull FingerprintManager.AuthenticationResult result) {
                byte[] protectedKey = FingerprintAuthenticator.this.protectKeyWithCipher(request.getKeyToProtect(), result.getCryptoObject().getCipher());
                if (protectedKey != null) {
                    dispatcher.dispatchSuccess(protectedKey);
                } else {
                    dispatcher.dispatchError(14, "Failed to encrypt biometric key.");
                }
            }

            @Override
            public void onAuthenticationFailure(@NonNull PowerAuthErrorException exception) {
                dispatcher.dispatchError(exception);
            }

            @Override
            public void onAuthenticationCancel(boolean userCancel) {
                if (userCancel) {
                    dispatcher.dispatchUserCancel();
                }
            }
        });
        dispatcher.setOnCancelListener(new CancelableTask.OnCancelListener(){

            @Override
            public void onCancel() {
                dialogFragment.dismiss();
            }
        });
        dialogFragment.setFingerprintAuthenticationHandler(handler);
        dialogFragment.show(fragmentManager);
        return dispatcher.getCancelableTask();
    }

    @Nullable
    private FingerprintManager.CryptoObject getCryptoObject(@Nullable SecretKey secretKey) {
        if (secretKey == null) {
            return null;
        }
        Cipher cipher = BiometricHelper.createAesCipher(secretKey);
        if (cipher == null) {
            return null;
        }
        return new FingerprintManager.CryptoObject(cipher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private byte[] protectKeyWithCipher(@NonNull byte[] keyToProtect, @Nullable Cipher cipher) {
        if (cipher == null) {
            return null;
        }
        FingerprintAuthenticator fingerprintAuthenticator = this;
        synchronized (fingerprintAuthenticator) {
            if (this.alreadyProtectedKey == null) {
                this.alreadyProtectedKey = BiometricHelper.protectKeyWithCipher(keyToProtect, cipher);
                if (this.alreadyProtectedKey == null) {
                    this.alreadyProtectedKey = new byte[0];
                }
            }
            return this.alreadyProtectedKey.length > 0 ? this.alreadyProtectedKey : null;
        }
    }
}

