/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl.legacy;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.StringRes;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import io.getlime.security.powerauth.biometry.BiometricDialogResources;
import io.getlime.security.powerauth.biometry.impl.legacy.FingerprintAuthenticationHandler;

@RequiresApi(api=23)
public class FingerprintAuthenticationDialogFragment
extends DialogFragment
implements FingerprintAuthenticationHandler.ProgressListener {
    private static final String ARG_RESOURCES = "arg_resources";
    private static final String ARG_TITLE = "arg_title";
    private static final String ARG_DESCRIPTION = "arg_description";
    private static final String FINGERPRINT_DEFAULT_TAG = "FINGERPRINT_DEFAULT_TAG";
    static final long WRN_TIMEOUT_MILLIS = 1600L;
    static final long ERROR_DELAY_MILLIS = 2400L;
    static final long SUCCESS_DELAY_MILLIS = 800L;
    private boolean mHasResult;
    private View mView;
    private ImageView mImgIcon;
    private TextView mTxtStatus;
    private TextView mTxtDescription;
    private BiometricDialogResources mResources;
    private final Runnable mResetStatusTextRunnable = new Runnable(){

        @Override
        public void run() {
            Context context = FingerprintAuthenticationDialogFragment.this.getContext();
            if (FingerprintAuthenticationDialogFragment.this.isAdded() && context != null) {
                FingerprintAuthenticationDialogFragment.this.mTxtStatus.setText(((FingerprintAuthenticationDialogFragment)FingerprintAuthenticationDialogFragment.this).mResources.strings.statusTouchSensor);
                FingerprintAuthenticationDialogFragment.this.mImgIcon.setImageResource(((FingerprintAuthenticationDialogFragment)FingerprintAuthenticationDialogFragment.this).mResources.drawables.fingerprintIcon);
                FingerprintAuthenticationDialogFragment.this.mImgIcon.setContentDescription(context.getText(((FingerprintAuthenticationDialogFragment)FingerprintAuthenticationDialogFragment.this).mResources.strings.accessibilityFingerprintIcon));
                FingerprintAuthenticationDialogFragment.this.mTxtStatus.setTextColor(FingerprintAuthenticationDialogFragment.this.getContext().getColor(((FingerprintAuthenticationDialogFragment)FingerprintAuthenticationDialogFragment.this).mResources.colors.secondaryText));
                FingerprintAuthenticationDialogFragment.this.announceMessageToAccessibility(context.getText(((FingerprintAuthenticationDialogFragment)FingerprintAuthenticationDialogFragment.this).mResources.strings.accessibilityTryAgainAnnouncement));
            }
        }
    };
    private CharSequence mLastAnnouncedMessageForAccessibility;
    @Nullable
    private FingerprintAuthenticationHandler mHandler;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mResources = BiometricDialogResources.unpackResources(bundle.getIntArray(ARG_RESOURCES));
        }
    }

    @NonNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        View view;
        Bundle bundle = this.getArguments();
        FragmentActivity activity = this.getActivity();
        if (activity == null || bundle == null) {
            throw new IllegalStateException("Activity or dialog arguments are missing.");
        }
        Context context = activity.getApplicationContext();
        AlertDialog.Builder alertBuilder = new AlertDialog.Builder((Context)this.getActivity());
        LayoutInflater layoutInflater = activity.getLayoutInflater();
        this.mView = view = layoutInflater.inflate(this.mResources.layout.dialogLayout, null);
        this.mImgIcon = (ImageView)view.findViewById(this.mResources.layout.statusImageView);
        this.mTxtStatus = (TextView)view.findViewById(this.mResources.layout.statusTextView);
        this.mTxtDescription = (TextView)view.findViewById(this.mResources.layout.descriptionTextView);
        view.setBackgroundResource(this.mResources.colors.background);
        alertBuilder.setTitle(bundle.getCharSequence(ARG_TITLE));
        this.mTxtDescription.setText(bundle.getCharSequence(ARG_DESCRIPTION));
        this.mTxtDescription.setTextColor(context.getColor(this.mResources.colors.primaryText));
        this.mTxtStatus.setText(this.mResources.strings.statusTouchSensor);
        this.mTxtStatus.setTextColor(context.getColor(this.mResources.colors.secondaryText));
        this.mImgIcon.setImageResource(this.mResources.drawables.fingerprintIcon);
        this.mImgIcon.setContentDescription(context.getText(this.mResources.strings.accessibilityFingerprintIcon));
        alertBuilder.setPositiveButton(this.mResources.strings.close, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int i) {
                FingerprintAuthenticationDialogFragment.this.reportResult();
            }
        });
        alertBuilder.setView(view);
        final AlertDialog alertDialog = alertBuilder.create();
        alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialogInterface) {
                if (FingerprintAuthenticationDialogFragment.this.isAdded()) {
                    int color2 = alertDialog.getContext().getColor(((FingerprintAuthenticationDialogFragment)FingerprintAuthenticationDialogFragment.this).mResources.colors.closeButtonText);
                    alertDialog.getButton(-1).setTextColor(color2);
                }
            }
        });
        alertDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    FingerprintAuthenticationDialogFragment.this.reportResult();
                }
                return true;
            }
        });
        return alertDialog;
    }

    public void onResume() {
        super.onResume();
        if (this.mHandler != null) {
            this.mHandler.startListening();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mHandler != null) {
            this.mHandler.stopListening();
        }
        this.reportResult();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mHandler != null) {
            this.mHandler.removeProgressListener();
        }
    }

    @Override
    public void onAuthenticationError(int errorCode, CharSequence errString) {
        if (this.isAdded()) {
            this.showError(errString);
        }
    }

    @Override
    public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
        if (this.isAdded()) {
            this.showWarning(helpString);
        }
    }

    @Override
    public void onAuthenticationFailed() {
        if (this.isAdded()) {
            this.showWarning(this.getContext().getText(this.mResources.strings.statusFingerprintNotRecognized));
        }
    }

    @Override
    public void onAuthenticationSuccess() {
        if (this.isAdded()) {
            this.showSuccess();
        }
    }

    @Override
    public void onAuthenticationCancel() {
        this.reportResult();
    }

    private void reportResult() {
        if (this.mHandler != null) {
            this.mHandler.reportResult();
        }
        this.dismiss();
    }

    private void showError(CharSequence error) {
        Context context = this.getContext();
        if (this.mHasResult || context == null) {
            return;
        }
        this.mHasResult = true;
        this.mImgIcon.setImageResource(this.mResources.drawables.errorIcon);
        this.mImgIcon.setContentDescription(context.getText(this.mResources.strings.accessibilityFailureIcon));
        this.mTxtStatus.setText(error);
        this.mTxtStatus.setTextColor(context.getColor(this.mResources.colors.failureText));
        this.mTxtStatus.removeCallbacks(this.mResetStatusTextRunnable);
        this.mImgIcon.postDelayed(new Runnable(){

            @Override
            public void run() {
                FingerprintAuthenticationDialogFragment.this.reportResult();
            }
        }, 2400L);
        this.announceMessageToAccessibility(error);
    }

    private void showWarning(CharSequence warning) {
        Context context = this.getContext();
        if (this.mHasResult || context == null) {
            return;
        }
        this.mImgIcon.setImageResource(this.mResources.drawables.errorIcon);
        this.mImgIcon.setContentDescription(context.getText(this.mResources.strings.accessibilityFailureIcon));
        this.mTxtStatus.setText(warning);
        this.mTxtStatus.setTextColor(context.getColor(this.mResources.colors.failureText));
        this.mTxtStatus.removeCallbacks(this.mResetStatusTextRunnable);
        this.mTxtStatus.postDelayed(this.mResetStatusTextRunnable, 1600L);
        this.announceMessageToAccessibility(warning);
    }

    private void showSuccess() {
        Context context = this.getContext();
        if (this.mHasResult || context == null) {
            return;
        }
        this.mHasResult = true;
        this.mImgIcon.setImageResource(this.mResources.drawables.successIcon);
        this.mImgIcon.setContentDescription(context.getText(this.mResources.strings.accessibilitySuccessIcon));
        this.mTxtStatus.setText(this.mResources.strings.statusSuccess);
        this.mTxtStatus.setTextColor(context.getColor(this.mResources.colors.successText));
        this.mTxtStatus.removeCallbacks(this.mResetStatusTextRunnable);
        this.mImgIcon.postDelayed(new Runnable(){

            @Override
            public void run() {
                FingerprintAuthenticationDialogFragment.this.reportResult();
            }
        }, 800L);
        this.announceMessageToAccessibility(context.getText(this.mResources.strings.accessibilitySuccessAnnouncement));
    }

    private void announceMessageToAccessibility(@NonNull CharSequence message) {
        if (!this.isAdded()) {
            return;
        }
        if (this.mLastAnnouncedMessageForAccessibility != null && this.mLastAnnouncedMessageForAccessibility.equals(message)) {
            return;
        }
        this.mView.announceForAccessibility(message);
        this.mLastAnnouncedMessageForAccessibility = message;
    }

    public void setFingerprintAuthenticationHandler(@NonNull FingerprintAuthenticationHandler handler) {
        this.mHandler = handler;
    }

    public void show(@NonNull FragmentManager fragmentManager) {
        this.show(fragmentManager, FINGERPRINT_DEFAULT_TAG);
    }

    public static class Builder {
        @NonNull
        private final Context context;
        private CharSequence title;
        private CharSequence description;
        private BiometricDialogResources resources;

        public Builder(@NonNull Context context) {
            this.context = context;
        }

        public Builder setTitle(@NonNull CharSequence title) {
            this.title = title;
            return this;
        }

        public Builder setTitle(@StringRes int titleId) {
            this.title = this.context.getText(titleId);
            return this;
        }

        public Builder setDescription(@NonNull CharSequence description) {
            this.description = description;
            return this;
        }

        public Builder setDescription(@StringRes int descriptionId) {
            this.description = this.context.getText(descriptionId);
            return this;
        }

        public Builder setDialogResources(@NonNull BiometricDialogResources resources) {
            this.resources = resources;
            return this;
        }

        public FingerprintAuthenticationDialogFragment build() {
            if (this.title == null || this.description == null) {
                throw new IllegalArgumentException("Title or description parameter is missing.");
            }
            if (this.resources == null) {
                throw new IllegalArgumentException("Dialog resources parameter is missing.");
            }
            FingerprintAuthenticationDialogFragment dialogFragment = new FingerprintAuthenticationDialogFragment();
            Bundle bundle = new Bundle();
            bundle.putCharSequence(FingerprintAuthenticationDialogFragment.ARG_TITLE, this.title);
            bundle.putCharSequence(FingerprintAuthenticationDialogFragment.ARG_DESCRIPTION, this.description);
            bundle.putIntArray(FingerprintAuthenticationDialogFragment.ARG_RESOURCES, this.resources.packResources());
            dialogFragment.setArguments(bundle);
            dialogFragment.setCancelable(false);
            return dialogFragment;
        }
    }
}

