/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.app.FragmentManager;
import io.getlime.security.powerauth.biometry.BiometricAuthenticationRequest;
import io.getlime.security.powerauth.biometry.BiometricDialogResources;
import io.getlime.security.powerauth.biometry.IBiometricAuthenticationCallback;
import io.getlime.security.powerauth.biometry.IBiometricKeystore;
import io.getlime.security.powerauth.biometry.impl.BiometricAuthenticator;
import io.getlime.security.powerauth.biometry.impl.BiometricErrorDialogFragment;
import io.getlime.security.powerauth.biometry.impl.BiometricHelper;
import io.getlime.security.powerauth.biometry.impl.BiometricKeystore;
import io.getlime.security.powerauth.biometry.impl.BiometricResultDispatcher;
import io.getlime.security.powerauth.biometry.impl.IBiometricAuthenticator;
import io.getlime.security.powerauth.biometry.impl.PrivateRequestData;
import io.getlime.security.powerauth.biometry.impl.dummy.DummyBiometricAuthenticator;
import io.getlime.security.powerauth.biometry.impl.dummy.DummyBiometricKeystore;
import io.getlime.security.powerauth.biometry.impl.legacy.FingerprintAuthenticator;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.networking.interfaces.ICancelable;
import io.getlime.security.powerauth.sdk.impl.CancelableTask;
import io.getlime.security.powerauth.sdk.impl.DefaultCallbackDispatcher;
import javax.crypto.SecretKey;

public class BiometricAuthentication {
    @NonNull
    public static IBiometricKeystore getBiometricKeystore() {
        if (Build.VERSION.SDK_INT >= 23) {
            return new BiometricKeystore();
        }
        return new DummyBiometricKeystore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBiometricAuthenticationAvailable(@NonNull Context context) {
        Class<SharedContext> clazz = SharedContext.class;
        synchronized (SharedContext.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return BiometricAuthentication.getContext().getAuthenticator(context).isAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int canAuthenticate(@NonNull Context context) {
        Class<SharedContext> clazz = SharedContext.class;
        synchronized (SharedContext.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return BiometricAuthentication.getContext().getAuthenticator(context).canAuthenticate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    @NonNull
    public static ICancelable authenticate(@NonNull Context context, @NonNull FragmentManager fragmentManager, @NonNull BiometricAuthenticationRequest request, @NonNull IBiometricAuthenticationCallback callback) {
        Class<SharedContext> clazz = SharedContext.class;
        synchronized (SharedContext.class) {
            SharedContext ctx = BiometricAuthentication.getContext();
            IBiometricAuthenticator device = ctx.getAuthenticator(context);
            BiometricResultDispatcher dispatcher = new BiometricResultDispatcher(callback, new DefaultCallbackDispatcher());
            PrivateRequestData requestData = new PrivateRequestData(request, dispatcher, ctx.getBiometricDialogResources());
            int status = device.canAuthenticate();
            PowerAuthErrorException exception = null;
            if (status == 0) {
                try {
                    requestData.setSecretKey(BiometricAuthentication.prepareSecretKey(device.getBiometricKeystore(), request.isForceGenerateNewKey()));
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return device.authenticate(context, fragmentManager, requestData);
                }
                catch (PowerAuthErrorException e) {
                    exception = e;
                    status = 3;
                }
            }
            device.getBiometricKeystore().removeDefaultKey();
            if (exception == null) {
                exception = BiometricHelper.getExceptionForBiometricStatus(status);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return BiometricAuthentication.showErrorDialog(status, exception, context, fragmentManager, requestData);
        }
    }

    @NonNull
    private static SecretKey prepareSecretKey(IBiometricKeystore keystore, boolean createNewKey) throws PowerAuthErrorException {
        SecretKey key;
        if (createNewKey) {
            key = keystore.generateDefaultKey();
            if (key == null) {
                throw new PowerAuthErrorException(18, "Keystore failed to generate a new biometric key.");
            }
        } else {
            key = keystore.getDefaultKey();
            if (key == null) {
                throw new PowerAuthErrorException(18, "Cannot get biometric key from the keystore.");
            }
        }
        return key;
    }

    @NonNull
    private static ICancelable showErrorDialog(int status, final @NonNull PowerAuthErrorException exception, @NonNull Context context, @NonNull FragmentManager fragmentManager, final @NonNull PrivateRequestData requestData) {
        int errorDescription;
        int errorTitle;
        CancelableTask cancelableTask = requestData.getDispatcher().getCancelableTask();
        BiometricDialogResources resources = requestData.getResources();
        if (status == 2) {
            errorTitle = resources.strings.errorEnrollFingerprintTitle;
            errorDescription = resources.strings.errorEnrollFingerprintDescription;
        } else if (status == 1) {
            errorTitle = resources.strings.errorNoFingerprintScannerTitle;
            errorDescription = resources.strings.errorNoFingerprintScannerDescription;
        } else if (status == 3) {
            errorTitle = resources.strings.errorFingerprintDisabledTitle;
            errorDescription = resources.strings.errorFingerprintDisabledDescription;
        } else {
            errorTitle = resources.strings.errorFingerprintDisabledTitle;
            errorDescription = resources.strings.errorFingerprintDisabledDescription;
        }
        final BiometricErrorDialogFragment dialogFragment = new BiometricErrorDialogFragment.Builder(context).setTitle(errorTitle).setMessage(errorDescription).setCloseButton(resources.strings.ok, resources.colors.closeButtonText).setIcon(resources.drawables.errorIcon).setOnCloseListener(new BiometricErrorDialogFragment.OnCloseListener(){

            @Override
            public void onClose() {
                requestData.getDispatcher().dispatchError(exception);
            }
        }).build();
        requestData.getDispatcher().setOnCancelListener(new CancelableTask.OnCancelListener(){

            @Override
            public void onCancel() {
                dialogFragment.dismiss();
            }
        });
        dialogFragment.show(fragmentManager, "BIOMETRIC_ERROR_DEFAULT_TAG");
        return cancelableTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBiometricDialogResources(@NonNull BiometricDialogResources resources) {
        Class<SharedContext> clazz = SharedContext.class;
        synchronized (SharedContext.class) {
            BiometricAuthentication.getContext().setBiometricDialogResources(resources);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public BiometricDialogResources getBiometricDialogResources() {
        Class<SharedContext> clazz = SharedContext.class;
        synchronized (SharedContext.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return BiometricAuthentication.getContext().getBiometricDialogResources();
        }
    }

    @NonNull
    private static SharedContext getContext() {
        return SharedContext.INSTANCE;
    }

    private static class SharedContext {
        private static final SharedContext INSTANCE = new SharedContext();
        @NonNull
        private BiometricDialogResources biometricDialogResources = new BiometricDialogResources.Builder().build();
        @Nullable
        private IBiometricAuthenticator authenticator = null;

        private SharedContext() {
        }

        void setBiometricDialogResources(@NonNull BiometricDialogResources resources) {
            this.biometricDialogResources = resources;
        }

        @NonNull
        BiometricDialogResources getBiometricDialogResources() {
            return this.biometricDialogResources;
        }

        @NonNull
        IBiometricAuthenticator getAuthenticator(@NonNull Context context) {
            IBiometricAuthenticator newAuthenticator;
            if (this.authenticator != null) {
                return this.authenticator;
            }
            if (Build.VERSION.SDK_INT >= 28 && (newAuthenticator = BiometricAuthenticator.createAuthenticator(context, BiometricAuthentication.getBiometricKeystore())) != null) {
                return newAuthenticator;
            }
            if (Build.VERSION.SDK_INT >= 23 && (newAuthenticator = FingerprintAuthenticator.createAuthenticator(context, BiometricAuthentication.getBiometricKeystore())) != null) {
                return newAuthenticator;
            }
            this.authenticator = new DummyBiometricAuthenticator();
            return this.authenticator;
        }
    }
}

