/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.networking.client;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.security.powerauth.core.EciesCryptogram;
import io.getlime.security.powerauth.core.EciesEncryptor;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.nio.charset.Charset;

public class JsonSerialization {
    private Gson gson;
    private JsonParser parser;
    private static final byte[] EMPTY_OBJECT_BYTES = new byte[]{123, 125};

    @NonNull
    public <TRequest> byte[] serializeObject(@Nullable TRequest object) {
        if (object != null) {
            String jsonString = this.getGson().toJson(object);
            return jsonString.getBytes(Charset.defaultCharset());
        }
        return EMPTY_OBJECT_BYTES;
    }

    @NonNull
    public <TResponse> TResponse deserializeObject(@Nullable byte[] data, @NonNull TypeToken<TResponse> type) throws JsonParseException {
        if (data != null) {
            String jsonString = new String(data, Charset.defaultCharset());
            Object object = this.getGson().fromJson(jsonString, type.getType());
            if (object != null) {
                return (TResponse)object;
            }
        }
        String message = data == null ? "Empty response received." : "Failed to deserialize object.";
        throw new JsonParseException(message);
    }

    @NonNull
    public <TRequest> byte[] serializeRequestObject(@Nullable TRequest object) {
        if (object != null) {
            ObjectRequest request = new ObjectRequest(object);
            String jsonString = this.getGson().toJson((Object)request);
            return jsonString.getBytes(Charset.defaultCharset());
        }
        return EMPTY_OBJECT_BYTES;
    }

    @NonNull
    public JsonObject parseResponseObject(@Nullable byte[] data) throws JsonParseException {
        if (data == null || data.length == 0) {
            throw new JsonParseException("Empty response received.");
        }
        String jsonString = new String(data, Charset.defaultCharset());
        JsonElement jsonRoot = this.getParser().parse(jsonString);
        if (!jsonRoot.isJsonObject()) {
            throw new JsonParseException("Unexpected type of JSON data.");
        }
        return jsonRoot.getAsJsonObject();
    }

    @NonNull
    public <TRequest> byte[] encryptObject(@Nullable TRequest object, @NonNull EciesEncryptor encryptor) throws PowerAuthErrorException {
        EciesEncryptedRequest request = this.encryptObjectToRequest(object, encryptor);
        return this.serializeObject(request);
    }

    @NonNull
    public byte[] decryptData(@Nullable byte[] data, @NonNull EciesEncryptor decryptor) throws PowerAuthErrorException {
        EciesEncryptedResponse response = (EciesEncryptedResponse)this.deserializeObject(data, TypeToken.get(EciesEncryptedResponse.class));
        EciesCryptogram cryptogram = new EciesCryptogram(response.getEncryptedData(), response.getMac());
        byte[] plainData = decryptor.decryptResponse(cryptogram);
        if (plainData == null) {
            throw new PowerAuthErrorException(14, "Failed to decrypt object data.");
        }
        return plainData;
    }

    @Nullable
    public <TResponse> TResponse decryptObject(@Nullable byte[] data, @NonNull EciesEncryptor decryptor, @Nullable TypeToken<TResponse> type) throws PowerAuthErrorException {
        byte[] plainData = this.decryptData(data, decryptor);
        if (type == null) {
            return null;
        }
        return this.deserializeObject(plainData, type);
    }

    @NonNull
    public <TRequest> EciesEncryptedRequest encryptObjectToRequest(@Nullable TRequest object, @NonNull EciesEncryptor encryptor) throws PowerAuthErrorException {
        byte[] plainData = this.serializeObject(object);
        EciesCryptogram cryptogram = encryptor.encryptRequest(plainData);
        if (cryptogram == null) {
            throw new PowerAuthErrorException(14, "Failed to encrypt object data.");
        }
        EciesEncryptedRequest request = new EciesEncryptedRequest();
        request.setEncryptedData(cryptogram.getBodyBase64());
        request.setEphemeralPublicKey(cryptogram.getKeyBase64());
        request.setMac(cryptogram.getMacBase64());
        return request;
    }

    @NonNull
    public <TResponse> TResponse decryptObjectFromResponse(@Nullable EciesEncryptedResponse response, @NonNull EciesEncryptor decryptor, @NonNull TypeToken<TResponse> type) throws PowerAuthErrorException {
        if (response == null) {
            throw new PowerAuthErrorException(14, "Empty response cannot be decrypted.");
        }
        EciesCryptogram cryptogram = new EciesCryptogram(response.getEncryptedData(), response.getMac());
        byte[] plainData = decryptor.decryptResponse(cryptogram);
        if (plainData == null) {
            throw new PowerAuthErrorException(14, "Failed to decrypt object data.");
        }
        return this.deserializeObject(plainData, type);
    }

    @NonNull
    public Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().create();
        }
        return this.gson;
    }

    @NonNull
    public JsonParser getParser() {
        if (this.parser == null) {
            this.parser = new JsonParser();
        }
        return this.parser;
    }
}

