/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.networking.client;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import io.getlime.core.rest.model.base.entity.Error;
import io.getlime.security.powerauth.core.EciesEncryptor;
import io.getlime.security.powerauth.ecies.EciesEncryptorId;
import io.getlime.security.powerauth.ecies.EciesMetadata;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.networking.client.JsonSerialization;
import io.getlime.security.powerauth.networking.exceptions.ErrorResponseApiException;
import io.getlime.security.powerauth.networking.exceptions.FailedApiException;
import io.getlime.security.powerauth.networking.interfaces.IEndpointDefinition;
import io.getlime.security.powerauth.sdk.PowerAuthAuthentication;
import io.getlime.security.powerauth.sdk.PowerAuthAuthorizationHttpHeader;
import io.getlime.security.powerauth.sdk.impl.IPrivateCryptoHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

class HttpRequestHelper<TRequest, TResponse> {
    private final TRequest requestObject;
    private final IEndpointDefinition<TResponse> endpoint;
    private final PowerAuthAuthentication authentication;
    private final JsonSerialization serialization;
    private EciesEncryptor encryptor;

    HttpRequestHelper(@Nullable TRequest requestObject, @NonNull IEndpointDefinition<TResponse> endpoint, @Nullable PowerAuthAuthentication authentication) {
        this.requestObject = requestObject;
        this.endpoint = endpoint;
        this.authentication = authentication;
        this.serialization = new JsonSerialization();
    }

    @NonNull
    RequestData buildRequest(@NonNull String baseUrl, @NonNull IPrivateCryptoHelper helper) throws PowerAuthErrorException, MalformedURLException {
        byte[] requestData;
        boolean needsEncryption;
        boolean needsSignature = this.endpoint.getAuthorizationUriId() != null;
        boolean bl = needsEncryption = this.endpoint.getEncryptorId() != EciesEncryptorId.NONE;
        if (needsSignature && this.authentication == null) {
            throw new PowerAuthErrorException(15, "Authentication object is missing.");
        }
        URL requestUrl = new URL(baseUrl + this.endpoint.getRelativePath());
        String requestMethod = this.endpoint.getHttpMethod();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (!needsEncryption) {
            this.encryptor = null;
            requestData = this.serialization.serializeRequestObject(this.requestObject);
        } else {
            this.encryptor = helper.getEciesEncryptor(this.endpoint.getEncryptorId());
            requestData = this.serialization.encryptObject(this.requestObject, this.encryptor);
            if (!needsSignature) {
                EciesMetadata metadata = this.encryptor.getMetadata();
                requestHeaders.put(metadata.getHttpHeaderKey(), metadata.getHttpHeaderValue());
            }
        }
        if (needsSignature) {
            boolean available = this.endpoint.isAvailableInProtocolUpgrade();
            PowerAuthAuthorizationHttpHeader header = helper.getAuthorizationHeader(available, requestData, requestMethod, this.endpoint.getAuthorizationUriId(), this.authentication);
            if (header.getPowerAuthErrorCode() != 0) {
                if (header.getPowerAuthErrorCode() == 17) {
                    throw new PowerAuthErrorException(header.getPowerAuthErrorCode(), "Request is temporarily unavailable, due to pending protocol upgrade.");
                }
                throw new PowerAuthErrorException(header.getPowerAuthErrorCode());
            }
            requestHeaders.put(header.getKey(), header.getValue());
        }
        requestHeaders.put("Content-Type", "application/json");
        requestHeaders.put("Accept", "application/json");
        return new RequestData(requestUrl, requestMethod, requestHeaders, requestData);
    }

    @Nullable
    TResponse buildResponse(int responseCode, @Nullable byte[] responseData) throws Throwable {
        if (responseCode != 200) {
            throw this.buildResponseException(responseCode, responseData, null, null);
        }
        try {
            return this.buildResponseObject(responseCode, responseData);
        }
        catch (PowerAuthErrorException | FailedApiException e) {
            throw e;
        }
        catch (Throwable e) {
            throw this.buildResponseException(responseCode, responseData, null, e);
        }
    }

    @Nullable
    private TResponse buildResponseObject(int responseCode, @Nullable byte[] responseData) throws Throwable {
        Object result;
        byte[] objectData;
        boolean unwrapResponse;
        if (this.encryptor != null) {
            unwrapResponse = false;
            objectData = this.serialization.decryptData(responseData, this.encryptor);
        } else {
            unwrapResponse = true;
            objectData = responseData;
        }
        if (unwrapResponse) {
            JsonObject jsonRoot = this.serialization.parseResponseObject(objectData);
            JsonElement status = jsonRoot.get("status");
            if (status == null || !status.isJsonPrimitive() || !status.getAsString().equalsIgnoreCase("OK")) {
                throw this.buildResponseException(responseCode, responseData, jsonRoot, null);
            }
            if (this.endpoint.getResponseType() != null) {
                JsonElement responseObjectElement = jsonRoot.get("responseObject");
                result = responseObjectElement != null && responseObjectElement.isJsonObject() ? this.serialization.getGson().fromJson(responseObjectElement, this.endpoint.getResponseType().getType()) : null;
                if (result == null) {
                    throw new JsonParseException("Failed to deserialize response object.");
                }
            } else {
                result = null;
            }
        } else {
            result = this.endpoint.getResponseType() != null ? (Object)this.serialization.deserializeObject(objectData, this.endpoint.getResponseType()) : null;
        }
        return (TResponse)result;
    }

    @NonNull
    private Throwable buildResponseException(int responseCode, @Nullable byte[] responseData, @Nullable JsonObject jsonRoot, @Nullable Throwable exception) {
        String responseString = responseData != null ? new String(responseData, Charset.defaultCharset()) : null;
        if (jsonRoot == null) {
            try {
                jsonRoot = this.serialization.parseResponseObject(responseData);
            }
            catch (JsonParseException e) {
                exception = e;
            }
        }
        if (jsonRoot != null) {
            try {
                JsonElement responseObjectElement = jsonRoot.get("responseObject");
                if (responseObjectElement != null && responseObjectElement.isJsonObject()) {
                    Error errorResponse = (Error)this.serialization.getGson().fromJson(responseObjectElement, TypeToken.get(Error.class).getType());
                    return new ErrorResponseApiException(errorResponse, responseCode, responseString, jsonRoot);
                }
            }
            catch (JsonParseException e) {
                exception = e;
            }
        }
        if (exception != null) {
            return new FailedApiException(exception.getMessage(), responseCode, responseString, jsonRoot);
        }
        return new FailedApiException(responseCode, responseString, jsonRoot);
    }

    static class RequestData {
        @NonNull
        final URL url;
        @NonNull
        final String method;
        @NonNull
        final Map<String, String> httpHeaders;
        @Nullable
        final byte[] body;

        RequestData(@NonNull URL url, @NonNull String method, @NonNull Map<String, String> httpHeaders, @Nullable byte[] body) {
            this.url = url;
            this.method = method;
            this.httpHeaders = httpHeaders;
            this.body = body;
        }
    }
}

