/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.networking.client;

import android.net.TrafficStats;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import io.getlime.security.powerauth.networking.client.HttpRequestHelper;
import io.getlime.security.powerauth.networking.interceptors.HttpRequestInterceptor;
import io.getlime.security.powerauth.networking.interfaces.ICancelable;
import io.getlime.security.powerauth.networking.interfaces.INetworkResponseListener;
import io.getlime.security.powerauth.networking.ssl.PA2ClientValidationStrategy;
import io.getlime.security.powerauth.sdk.PowerAuthClientConfiguration;
import io.getlime.security.powerauth.sdk.impl.IPrivateCryptoHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

class HttpClientTask<TRequest, TResponse>
extends AsyncTask<TRequest, Void, TResponse>
implements ICancelable {
    private static final int THREAD_STATS_TAG = 13398;
    private final HttpRequestHelper<TRequest, TResponse> httpRequestHelper;
    private final String baseUrl;
    private final IPrivateCryptoHelper cryptoHelper;
    private final INetworkResponseListener<TResponse> listener;
    private final PowerAuthClientConfiguration clientConfiguration;
    private Throwable error;

    HttpClientTask(@NonNull HttpRequestHelper<TRequest, TResponse> httpRequestHelper, @NonNull String baseUrl, @NonNull PowerAuthClientConfiguration clientConfiguration, @NonNull IPrivateCryptoHelper cryptoHelper, @NonNull INetworkResponseListener<TResponse> listener) {
        this.httpRequestHelper = httpRequestHelper;
        this.baseUrl = baseUrl;
        this.cryptoHelper = cryptoHelper;
        this.clientConfiguration = clientConfiguration;
        this.listener = listener;
    }

    private byte[] loadBytesFromInputStream(InputStream is) throws IOException {
        int length;
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
            if (!this.isCancelled()) continue;
            return null;
        }
        return result.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TResponse doInBackground(TRequest ... tRequests) {
        this.setThreadStatsTag();
        InputStream inputStream = null;
        HttpURLConnection urlConnection = null;
        try {
            boolean responseOk;
            HostnameVerifier hostnameVerifier;
            Object sslConnection;
            if (this.isCancelled()) {
                TResponse TResponse = null;
                return TResponse;
            }
            HttpRequestHelper.RequestData requestData = this.httpRequestHelper.buildRequest(this.baseUrl, this.cryptoHelper);
            urlConnection = (HttpURLConnection)requestData.url.openConnection();
            boolean securedUrlConnection = urlConnection instanceof HttpsURLConnection;
            urlConnection.setRequestMethod(requestData.method);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setConnectTimeout(this.clientConfiguration.getConnectionTimeout());
            urlConnection.setReadTimeout(this.clientConfiguration.getReadTimeout());
            for (Map.Entry<String, String> header : requestData.httpHeaders.entrySet()) {
                urlConnection.setRequestProperty(header.getKey(), header.getValue());
            }
            if (securedUrlConnection) {
                PA2ClientValidationStrategy clientValidationStrategy = this.clientConfiguration.getClientValidationStrategy();
                if (clientValidationStrategy != null) {
                    sslConnection = (HttpsURLConnection)urlConnection;
                    SSLSocketFactory sslSocketFactory = clientValidationStrategy.getSSLSocketFactory();
                    if (sslSocketFactory != null) {
                        ((HttpsURLConnection)sslConnection).setSSLSocketFactory(sslSocketFactory);
                    }
                    if ((hostnameVerifier = clientValidationStrategy.getHostnameVerifier()) != null) {
                        ((HttpsURLConnection)sslConnection).setHostnameVerifier(hostnameVerifier);
                    }
                }
            } else if (!this.clientConfiguration.isUnsecuredConnectionAllowed()) {
                throw new SSLException("Connection to non-TLS endpoint is not allowed.");
            }
            List<HttpRequestInterceptor> requestInterceptors = this.clientConfiguration.getRequestInterceptors();
            if (requestInterceptors != null) {
                for (HttpRequestInterceptor interceptor : requestInterceptors) {
                    interceptor.processRequestConnection(urlConnection);
                }
            }
            if (requestData.body != null) {
                urlConnection.getOutputStream().write(requestData.body);
            }
            urlConnection.connect();
            if (this.isCancelled()) {
                sslConnection = null;
                return (TResponse)sslConnection;
            }
            int responseCode = urlConnection.getResponseCode();
            boolean bl = responseOk = responseCode == 200;
            if (this.isCancelled()) {
                hostnameVerifier = null;
                return (TResponse)hostnameVerifier;
            }
            inputStream = responseOk ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            byte[] responseData = this.loadBytesFromInputStream(inputStream);
            if (this.isCancelled()) {
                TResponse TResponse = null;
                return TResponse;
            }
            TResponse TResponse = this.httpRequestHelper.buildResponse(responseCode, responseData);
            return TResponse;
        }
        catch (Throwable e) {
            this.error = e;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return null;
    }

    protected void onCancelled() {
        super.onCancelled();
        this.listener.onCancel();
    }

    protected void onPostExecute(TResponse response) {
        super.onPostExecute(response);
        if (this.error == null) {
            this.listener.onNetworkResponse(response);
        } else {
            this.listener.onNetworkError(this.error);
        }
    }

    @Override
    public void cancel() {
        this.cancel(true);
    }

    private void setThreadStatsTag() {
        if (TrafficStats.getThreadStatsTag() == -1) {
            TrafficStats.setThreadStatsTag((int)13398);
        }
    }
}

