/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.networking.client;

import android.net.TrafficStats;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import io.getlime.core.rest.model.base.entity.Error;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.security.powerauth.networking.endpoints.PA2ActivationStatusEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2CreateActivationEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2CreateTokenEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2NonPersonalizedEncryptedEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2RemoveActivationEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2RemoveTokenEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2VaultUnlockEndpoint;
import io.getlime.security.powerauth.networking.exceptions.ErrorResponseApiException;
import io.getlime.security.powerauth.networking.exceptions.FailedApiException;
import io.getlime.security.powerauth.networking.interfaces.ICancelable;
import io.getlime.security.powerauth.networking.interfaces.IEndpointDefinition;
import io.getlime.security.powerauth.networking.interfaces.INetworkResponseListener;
import io.getlime.security.powerauth.networking.ssl.PA2ClientValidationStrategy;
import io.getlime.security.powerauth.rest.api.model.entity.NonPersonalizedEncryptedPayloadModel;
import io.getlime.security.powerauth.rest.api.model.request.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.request.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.request.TokenCreateRequest;
import io.getlime.security.powerauth.rest.api.model.request.TokenRemoveRequest;
import io.getlime.security.powerauth.rest.api.model.request.VaultUnlockRequest;
import io.getlime.security.powerauth.rest.api.model.response.ActivationCreateResponse;
import io.getlime.security.powerauth.rest.api.model.response.ActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.model.response.TokenCreateResponse;
import io.getlime.security.powerauth.rest.api.model.response.TokenRemoveResponse;
import io.getlime.security.powerauth.rest.api.model.response.VaultUnlockResponse;
import io.getlime.security.powerauth.sdk.PowerAuthClientConfiguration;
import io.getlime.security.powerauth.sdk.PowerAuthConfiguration;
import io.getlime.security.powerauth.system.PA2Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

public class PA2Client {
    private final Gson mGson;
    private final Handler mHandler;
    private final PowerAuthConfiguration mConfiguration;
    private final PowerAuthClientConfiguration mClientConfiguration;
    private static final String EMPTY_OBJECT_STRING = "{}";
    private static final byte[] EMPTY_OBJECT_BYTES = new byte[]{123, 125};

    public PA2Client(@NonNull PowerAuthConfiguration configuration, @NonNull PowerAuthClientConfiguration clientConfiguration) {
        this.mConfiguration = configuration;
        this.mClientConfiguration = clientConfiguration;
        this.mGson = new GsonBuilder().create();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    @NonNull
    public PowerAuthClientConfiguration getClientConfiguration() {
        return this.mClientConfiguration;
    }

    @NonNull
    public PowerAuthConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    private String loadStringFromInputStream(InputStream is, String encoding) throws IOException {
        int length;
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return result.toString(encoding);
    }

    private <TRequest, TResponse> ICancelable execute(@NonNull IEndpointDefinition<TResponse> requestDefinition, @Nullable TRequest requestBody, @Nullable Map<String, String> headers, @NonNull INetworkResponseListener<TResponse> responseListener) {
        RestExecutor restExecutor = new RestExecutor(headers, requestDefinition, responseListener);
        restExecutor.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[]{requestBody, null, null});
        return restExecutor;
    }

    public <TRequest> Pair<byte[], String> serializeRequestObject(TRequest request) {
        if (request != null) {
            ObjectRequest requestObject = new ObjectRequest(request);
            String jsonString = this.mGson.toJson((Object)requestObject);
            byte[] jsonBytes = jsonString.getBytes(Charset.defaultCharset());
            return new Pair((Object)jsonBytes, (Object)jsonString);
        }
        return new Pair((Object)EMPTY_OBJECT_BYTES, (Object)EMPTY_OBJECT_STRING);
    }

    public <TResponse> TResponse deserializePlainResponse(byte[] data, Class<TResponse> type) {
        try {
            String jsonString = new String(data, Charset.defaultCharset());
            return (TResponse)this.mGson.fromJson(jsonString, type);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    @CheckResult
    public ICancelable sendNonPersonalizedEncryptedObjectToUrl(@NonNull NonPersonalizedEncryptedPayloadModel request, @NonNull String url, @NonNull Map<String, String> headers, @NonNull INetworkResponseListener<NonPersonalizedEncryptedPayloadModel> listener) {
        return this.execute(new PA2NonPersonalizedEncryptedEndpoint(url), request, headers, listener);
    }

    @CheckResult
    public ICancelable createActivation(@NonNull ActivationCreateRequest request, @NonNull INetworkResponseListener<ActivationCreateResponse> listener) {
        return this.execute(new PA2CreateActivationEndpoint(this.mConfiguration.getBaseEndpointUrl()), request, null, listener);
    }

    @CheckResult
    public ICancelable getActivationStatus(@NonNull ActivationStatusRequest request, @NonNull INetworkResponseListener<ActivationStatusResponse> listener) {
        return this.execute(new PA2ActivationStatusEndpoint(this.mConfiguration.getBaseEndpointUrl()), request, null, listener);
    }

    @CheckResult
    public ICancelable removeActivation(@NonNull Map<String, String> headers, @NonNull INetworkResponseListener<Void> listener) {
        return this.execute(new PA2RemoveActivationEndpoint(this.mConfiguration.getBaseEndpointUrl()), null, headers, listener);
    }

    @CheckResult
    public ICancelable vaultUnlock(@NonNull Map<String, String> headers, @NonNull VaultUnlockRequest request, @NonNull INetworkResponseListener<VaultUnlockResponse> listener) {
        return this.execute(new PA2VaultUnlockEndpoint(this.mConfiguration.getBaseEndpointUrl()), request, headers, listener);
    }

    @CheckResult
    public ICancelable createToken(@NonNull Map<String, String> headers, @NonNull TokenCreateRequest request, @NonNull INetworkResponseListener<TokenCreateResponse> listener) {
        return this.execute(new PA2CreateTokenEndpoint(this.mConfiguration.getBaseEndpointUrl()), request, headers, listener);
    }

    @CheckResult
    public ICancelable removeToken(@NonNull Map<String, String> headers, @NonNull TokenRemoveRequest request, @NonNull INetworkResponseListener<TokenRemoveResponse> listener) {
        return this.execute(new PA2RemoveTokenEndpoint(this.mConfiguration.getBaseEndpointUrl()), request, headers, listener);
    }

    private class RestExecutor<TRequest, TResponse>
    extends AsyncTask<TRequest, Void, Void>
    implements ICancelable {
        private static final int THREAD_STATS_TAG = 13398;
        private static final String CONTENT_TYPE_JSON = "application/json";
        private IEndpointDefinition<TRequest> requestDefinition;
        private INetworkResponseListener<TResponse> responseListener;
        @Nullable
        private Map<String, String> headers;

        private RestExecutor(@NonNull Map<String, String> headers, @NonNull IEndpointDefinition<TRequest> requestDefinition, INetworkResponseListener<TResponse> responseListener) {
            this.headers = headers;
            this.requestDefinition = requestDefinition;
            this.responseListener = responseListener;
        }

        protected Void doInBackground(TRequest ... params) {
            URL url;
            this.setThreadStatsTag();
            try {
                url = new URL(this.requestDefinition.getEndpoint());
            }
            catch (MalformedURLException e) {
                this.callOnErrorUi(e, this.responseListener);
                return null;
            }
            try {
                Pair<byte[], String> postData = PA2Client.this.serializeRequestObject(params[0]);
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                boolean securedUrlConnection = urlConnection instanceof HttpsURLConnection;
                urlConnection.setRequestMethod("POST");
                urlConnection.setDoOutput(true);
                urlConnection.setUseCaches(false);
                urlConnection.setRequestProperty("Content-Type", CONTENT_TYPE_JSON);
                urlConnection.setRequestProperty("Accept", CONTENT_TYPE_JSON);
                if (this.headers != null) {
                    for (Map.Entry<String, String> header : this.headers.entrySet()) {
                        urlConnection.setRequestProperty(header.getKey(), header.getValue());
                    }
                }
                urlConnection.setConnectTimeout(PA2Client.this.mClientConfiguration.getConnectionTimeout());
                urlConnection.setReadTimeout(PA2Client.this.mClientConfiguration.getReadTimeout());
                if (securedUrlConnection) {
                    PA2ClientValidationStrategy clientValidationStrategy = PA2Client.this.mClientConfiguration.getClientValidationStrategy();
                    if (clientValidationStrategy != null) {
                        HostnameVerifier hostnameVerifier;
                        HttpsURLConnection sslConnection = (HttpsURLConnection)urlConnection;
                        SSLSocketFactory sslSocketFactory = clientValidationStrategy.getSSLSocketFactory();
                        if (sslSocketFactory != null) {
                            sslConnection.setSSLSocketFactory(sslSocketFactory);
                        }
                        if ((hostnameVerifier = clientValidationStrategy.getHostnameVerifier()) != null) {
                            sslConnection.setHostnameVerifier(hostnameVerifier);
                        }
                    }
                } else if (!PA2Client.this.mClientConfiguration.isUnsecuredConnectionAllowed()) {
                    throw new SSLException("Connection to non-TLS endpoint is not allowed.");
                }
                if (PA2Log.isEnabled()) {
                    String bodyStr = postData.second == null ? "<empty>" : (String)postData.second;
                    Map<String, List<String>> prop = urlConnection.getRequestProperties();
                    String propStr = prop == null ? "<empty>" : prop.toString();
                    PA2Log.d("PA2Client %s request to URL: %s\n - Headers: %s\n - Body: %s", urlConnection.getRequestMethod(), url.toString(), propStr, bodyStr);
                }
                urlConnection.getOutputStream().write((byte[])postData.first);
                urlConnection.connect();
                int responseCode = urlConnection.getResponseCode();
                boolean responseOk = responseCode / 100 == 2;
                InputStream inputStream = responseOk ? urlConnection.getInputStream() : urlConnection.getErrorStream();
                String responseBody = PA2Client.this.loadStringFromInputStream(inputStream, urlConnection.getContentEncoding());
                if (PA2Log.isEnabled()) {
                    String bodyStr = responseBody == null ? "<empty body>" : responseBody;
                    Map<String, List<String>> prop = urlConnection.getHeaderFields();
                    String propStr = prop == null ? "<empty>" : prop.toString();
                    PA2Log.d("PA2Client response from URL: %s\n - Status code: %d\n - Headers: %s\n - Body: %s", url.toString(), responseCode, propStr, bodyStr);
                }
                String exceptionMessage = null;
                JsonObject responseJson = null;
                try {
                    JsonElement jsonRoot = new JsonParser().parse(responseBody);
                    JsonObject jsonObject = responseJson = jsonRoot.isJsonObject() ? jsonRoot.getAsJsonObject() : null;
                    if (responseJson != null) {
                        JsonElement statusElement = responseJson.get("status");
                        JsonElement responseElement = responseJson.get("responseObject");
                        if (statusElement != null && statusElement.isJsonPrimitive()) {
                            if (statusElement.getAsString().equalsIgnoreCase("OK")) {
                                if (this.requestDefinition.getResponseType() != null) {
                                    Object response = PA2Client.this.mGson.fromJson(responseElement, this.requestDefinition.getResponseType().getType());
                                    this.callOnResponseUi(response, this.responseListener);
                                } else {
                                    this.callOnResponseUi(null, this.responseListener);
                                }
                            } else {
                                Error error = (Error)PA2Client.this.mGson.fromJson(responseElement, TypeToken.get(Error.class).getType());
                                this.callOnErrorUi(new ErrorResponseApiException(error, responseCode, responseBody, responseJson), this.responseListener);
                            }
                            return null;
                        }
                    }
                }
                catch (JsonParseException e) {
                    exceptionMessage = e.getMessage();
                }
                this.callOnErrorUi(new FailedApiException(exceptionMessage, responseCode, responseBody, responseJson), this.responseListener);
            }
            catch (JsonParseException | IOException e) {
                this.callOnErrorUi(e, this.responseListener);
            }
            return null;
        }

        private <TResponse> void callOnResponseUi(final TResponse response, final INetworkResponseListener<TResponse> responseListener) {
            PA2Client.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (!RestExecutor.this.isCancelled()) {
                        responseListener.onNetworkResponse(response);
                    }
                }
            });
        }

        private <TResponse> void callOnErrorUi(final Throwable t, final INetworkResponseListener<TResponse> responseListener) {
            PA2Client.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (!RestExecutor.this.isCancelled()) {
                        responseListener.onNetworkError(t);
                    }
                }
            });
        }

        @Override
        public void cancel() {
            this.cancel(true);
        }

        private void setThreadStatsTag() {
            if (TrafficStats.getThreadStatsTag() == -1) {
                TrafficStats.setThreadStatsTag((int)13398);
            }
        }
    }
}

