/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public class PowerAuthAuthorizationHttpHeader {
    public final String key;
    public final String value;
    public final int powerAuthErrorCode;

    @NonNull
    public static PowerAuthAuthorizationHttpHeader createAuthorizationHeader(@NonNull String value) {
        return new PowerAuthAuthorizationHttpHeader("X-PowerAuth-Authorization", value, 0);
    }

    @NonNull
    public static PowerAuthAuthorizationHttpHeader createTokenHeader(@NonNull String value) {
        return new PowerAuthAuthorizationHttpHeader("X-PowerAuth-Token", value, 0);
    }

    @NonNull
    public static PowerAuthAuthorizationHttpHeader createError(int powerAuthErrorCode) {
        return new PowerAuthAuthorizationHttpHeader(null, null, powerAuthErrorCode);
    }

    public boolean isValid() {
        return this.powerAuthErrorCode == 0 && this.key != null && this.value != null;
    }

    private PowerAuthAuthorizationHttpHeader(@Nullable String key, @Nullable String value, int powerAuthErrorCode) {
        this.key = key;
        this.value = value;
        this.powerAuthErrorCode = powerAuthErrorCode;
    }

    public int getPowerAuthErrorCode() {
        return this.powerAuthErrorCode;
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }
}

