/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.getlime.security.powerauth.core.TokenCalculator;
import io.getlime.security.powerauth.sdk.PowerAuthTokenStore;
import io.getlime.security.powerauth.sdk.impl.PowerAuthAuthorizationHttpHeader;
import io.getlime.security.powerauth.sdk.impl.PowerAuthPrivateTokenData;

public class PowerAuthToken {
    public final PowerAuthTokenStore tokenStore;
    private final PowerAuthPrivateTokenData tokenData;

    public PowerAuthToken(@NonNull PowerAuthTokenStore store, @NonNull PowerAuthPrivateTokenData tokenData) {
        this.tokenStore = store;
        this.tokenData = tokenData;
    }

    public boolean isValid() {
        return this.tokenData != null && this.tokenStore != null && this.tokenData.hasValidData();
    }

    public boolean equals(Object anObject) {
        PowerAuthToken anotherToken;
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof PowerAuthToken && (anotherToken = (PowerAuthToken)anObject).isValid() && this.isValid()) {
            return this.tokenStore == anotherToken.tokenStore && this.tokenData.equals(anotherToken.tokenData);
        }
        return false;
    }

    @Nullable
    public String getTokenName() {
        return this.tokenData != null ? this.tokenData.name : null;
    }

    @Nullable
    public String getTokenIdentifier() {
        return this.tokenData != null ? this.tokenData.identifier : null;
    }

    public boolean canGenerateHeader() {
        return this.tokenStore != null && this.tokenStore.canRequestForAccessToken();
    }

    @NonNull
    public PowerAuthAuthorizationHttpHeader generateHeader() {
        int errorCode;
        if (this.isValid()) {
            if (this.tokenStore.canRequestForAccessToken()) {
                String headerValue = TokenCalculator.calculateTokenValue(this.tokenData);
                if (headerValue != null) {
                    return PowerAuthAuthorizationHttpHeader.createTokenHeader(headerValue);
                }
                errorCode = 2;
            } else {
                errorCode = 5;
            }
        } else {
            errorCode = 13;
        }
        return PowerAuthAuthorizationHttpHeader.createError(errorCode);
    }
}

