/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.keychain.fingerprint;

import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Build;
import android.os.CancellationSignal;
import android.support.annotation.RequiresApi;
import io.getlime.security.powerauth.keychain.fingerprint.FingerprintCallback;
import io.getlime.security.powerauth.keychain.fingerprint.FingerprintKeystore;
import io.getlime.security.powerauth.keychain.fingerprint.FingerprintStage;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

@RequiresApi(api=23)
public class FingerprintAuthenticationHandler
extends FingerprintManager.AuthenticationCallback {
    private FingerprintCallback mCallback;
    private final FingerprintManager mFingerprintManager;
    private CancellationSignal mCancellationSignal;
    private FingerprintManager.CryptoObject mCryptoObject;
    private FingerprintKeystore mKeyStore;
    private Cipher mCipher;
    private boolean mForceGenerateNewKey;

    private FingerprintAuthenticationHandler(FingerprintManager fingerprintManager, FingerprintCallback callback, boolean forceGenerateNewKey) {
        this.mFingerprintManager = fingerprintManager;
        this.mCallback = callback;
        this.mForceGenerateNewKey = forceGenerateNewKey;
        if (!this.initKeyStore()) {
            this.mCallback.onAuthenticationFailed();
        }
    }

    public void releaseFingerprintCallback() {
        this.mCallback = null;
    }

    public boolean isFingerprintAuthAvailable() throws SecurityException {
        return this.mFingerprintManager != null && this.mFingerprintManager.isHardwareDetected() && this.mFingerprintManager.hasEnrolledFingerprints();
    }

    public boolean hasFingerprintHardware() throws SecurityException {
        return this.mFingerprintManager != null && this.mFingerprintManager.isHardwareDetected();
    }

    public boolean hasEnrolledFingerprints() throws SecurityException {
        return this.mFingerprintManager != null && this.mFingerprintManager.hasEnrolledFingerprints();
    }

    public void startListening() throws SecurityException {
        if (this.isFingerprintAuthAvailable()) {
            this.mCancellationSignal = new CancellationSignal();
            this.mFingerprintManager.authenticate(this.mCryptoObject, this.mCancellationSignal, 0, (FingerprintManager.AuthenticationCallback)this, null);
        }
    }

    public void stopListening() {
        if (this.mCancellationSignal != null) {
            this.mCancellationSignal.cancel();
            this.mCancellationSignal = null;
        }
    }

    private boolean initKeyStore() {
        this.mKeyStore = new FingerprintKeystore();
        return this.mKeyStore.isKeystoreReady();
    }

    private boolean initCipher() {
        try {
            this.mCipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            SecretKey key = this.mKeyStore.getDefaultKey();
            if (key != null) {
                byte[] zero_iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                IvParameterSpec algorithmSpec = new IvParameterSpec(zero_iv);
                this.mCipher.init(1, (Key)key, algorithmSpec);
                return true;
            }
            return false;
        }
        catch (NoSuchPaddingException e) {
            return false;
        }
        catch (InvalidAlgorithmParameterException e) {
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        catch (InvalidKeyException e) {
            return false;
        }
    }

    public boolean removeKey() {
        return this.mKeyStore.removeDefaultKey();
    }

    public FingerprintStage initCrypto() {
        if (!this.hasFingerprintHardware()) {
            return FingerprintStage.INFO_FINGERPRINT_NOT_AVAILABLE;
        }
        if (!this.hasEnrolledFingerprints()) {
            return FingerprintStage.INFO_ENROLL_NEW_FINGERPRINT;
        }
        if (this.mForceGenerateNewKey ? !this.mKeyStore.generateDefaultKey() : !this.mKeyStore.containsDefaultKey()) {
            return FingerprintStage.INFO_FINGERPRINT_NOT_AVAILABLE;
        }
        if (this.initCipher()) {
            this.mCryptoObject = new FingerprintManager.CryptoObject(this.mCipher);
            if (this.mCryptoObject != null) {
                return FingerprintStage.USE_FINGERPRINT;
            }
            return FingerprintStage.INFO_ENROLL_NEW_FINGERPRINT;
        }
        return FingerprintStage.INFO_FINGERPRINT_INVALIDATED;
    }

    public byte[] encryptedKey(byte[] biometryKey) {
        try {
            return this.mCipher.doFinal(biometryKey);
        }
        catch (IllegalBlockSizeException e) {
            return null;
        }
        catch (BadPaddingException e) {
            return null;
        }
    }

    public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
        super.onAuthenticationHelp(helpCode, helpString);
        if (this.mCallback != null) {
            this.mCallback.onAuthenticationHelp(helpString);
        }
    }

    public void onAuthenticationSucceeded(FingerprintManager.AuthenticationResult result) {
        super.onAuthenticationSucceeded(result);
        if (this.mCallback != null) {
            this.mCallback.onAuthenticated();
        }
    }

    public void onAuthenticationError(int errorCode, CharSequence errString) {
        super.onAuthenticationError(errorCode, errString);
        if (this.mCallback != null) {
            this.mCallback.onAuthenticationError(errString);
        }
    }

    public void onAuthenticationFailed() {
        super.onAuthenticationFailed();
        if (this.mCallback != null) {
            this.mCallback.onAuthenticationFailed();
        }
    }

    public static class FingerprintHelperBuilder {
        private final FingerprintManager mFingerPrintManager;
        private FingerprintCallback mCallback;
        private boolean mForceGenerateNewKey;

        public FingerprintHelperBuilder(Context context) {
            this.mFingerPrintManager = Build.VERSION.SDK_INT >= 23 ? (FingerprintManager)context.getSystemService("fingerprint") : null;
        }

        public FingerprintHelperBuilder forceGenerateNewKey(boolean forceGenerateNewKey) {
            this.mForceGenerateNewKey = forceGenerateNewKey;
            return this;
        }

        public FingerprintHelperBuilder callback(FingerprintCallback callback) {
            this.mCallback = callback;
            return this;
        }

        public FingerprintAuthenticationHandler build() {
            return new FingerprintAuthenticationHandler(this.mFingerPrintManager, this.mCallback, this.mForceGenerateNewKey);
        }
    }
}

