/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.core;

import io.getlime.security.powerauth.core.ActivationStatus;
import io.getlime.security.powerauth.core.ActivationStep1Param;
import io.getlime.security.powerauth.core.ActivationStep1Result;
import io.getlime.security.powerauth.core.ActivationStep2Param;
import io.getlime.security.powerauth.core.ActivationStep2Result;
import io.getlime.security.powerauth.core.Encryptor;
import io.getlime.security.powerauth.core.Password;
import io.getlime.security.powerauth.core.SessionSetup;
import io.getlime.security.powerauth.core.SignatureRequest;
import io.getlime.security.powerauth.core.SignatureResult;
import io.getlime.security.powerauth.core.SignatureUnlockKeys;
import io.getlime.security.powerauth.core.SignedData;
import java.util.ArrayList;
import java.util.Map;

public class Session {
    private long handle;

    public Session(SessionSetup setup) {
        this.handle = this.init(setup);
    }

    private native long init(SessionSetup var1);

    private native void destroy(long var1);

    public synchronized void destroy() {
        if (this.handle != 0L) {
            this.destroy(this.handle);
            this.handle = 0L;
        }
    }

    protected void finalize() {
        this.destroy();
    }

    public native SessionSetup getSessionSetup();

    public native void resetSession();

    public native boolean hasDebugFeatures();

    public native boolean hasValidSetup();

    public native byte[] serializedState();

    public native int deserializeState(byte[] var1);

    public native boolean canStartActivation();

    public native boolean hasPendingActivation();

    public native boolean hasValidActivation();

    public native String getActivationIdentifier();

    public native ActivationStep1Result startActivation(ActivationStep1Param var1);

    public native ActivationStep2Result validateActivationResponse(ActivationStep2Param var1);

    public native int completeActivation(SignatureUnlockKeys var1);

    public native ActivationStatus decodeActivationStatus(String var1, SignatureUnlockKeys var2);

    public byte[] prepareKeyValueDictionaryForDataSigning(Map<String, String> keyValueMap) {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<String, String> entry : keyValueMap.entrySet()) {
            keys.add(entry.getKey());
            values.add(entry.getValue());
        }
        return this.prepareKeyValueDictionaryForDataSigning(keys.toArray(new String[keys.size()]), values.toArray(new String[values.size()]));
    }

    private native byte[] prepareKeyValueDictionaryForDataSigning(String[] var1, String[] var2);

    public native SignatureResult signHTTPRequest(SignatureRequest var1, SignatureUnlockKeys var2, int var3);

    public native String getHttpAuthHeaderName();

    public native int verifyServerSignedData(SignedData var1);

    public native int changeUserPassword(Password var1, Password var2);

    public native int addBiometryFactor(String var1, SignatureUnlockKeys var2);

    public native boolean hasBiometryFactor();

    public native int removeBiometryFactor();

    public native byte[] deriveCryptographicKeyFromVaultKey(String var1, SignatureUnlockKeys var2, long var3);

    public native byte[] signDataWithDevicePrivateKey(String var1, SignatureUnlockKeys var2, byte[] var3);

    public native boolean hasExternalEncryptionKey();

    public native int setExternalEncryptionKey(byte[] var1);

    public native int addExternalEncryptionKey(byte[] var1);

    public native int removeExternalEncryptionKey();

    public native Encryptor createNonpersonalizedEncryptor(byte[] var1);

    public native Encryptor createPersonalizedEncryptor(byte[] var1, SignatureUnlockKeys var2);

    public native byte[] normalizeSignatureUnlockKeyFromData(byte[] var1);

    public native byte[] generateSignatureUnlockKey();

    static {
        System.loadLibrary("PowerAuth2Module");
    }
}

