/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.core;

import android.util.Pair;
import io.getlime.security.powerauth.core.ECIESCryptogram;

public class ECIESEncryptor {
    private long handle;

    public ECIESEncryptor(String publicKey, byte[] sharedInfo2) {
        this.handle = this.init(publicKey, sharedInfo2);
    }

    public ECIESEncryptor copyForDecryption() {
        long handleCopy = this.copyHandleForDecryption();
        if (handleCopy != 0L) {
            return new ECIESEncryptor(handleCopy);
        }
        return null;
    }

    private ECIESEncryptor(long handle) {
        this.handle = handle;
    }

    public synchronized void destroy() {
        if (this.handle != 0L) {
            this.destroy(this.handle);
            this.handle = 0L;
        }
    }

    protected void finalize() {
        this.destroy();
    }

    private native void destroy(long var1);

    private native long init(String var1, byte[] var2);

    private native long copyHandleForDecryption();

    public native String getPublicKey();

    public native byte[] getSharedInfo2();

    public native boolean canEncryptRequest();

    public native boolean canDecryptResponse();

    public native ECIESCryptogram encryptRequest(byte[] var1);

    public synchronized Pair<ECIESEncryptor, ECIESCryptogram> encryptRequestSynchronized(byte[] requestData) {
        ECIESEncryptor decryptor;
        ECIESCryptogram cryptogram = this.encryptRequest(requestData);
        if (cryptogram != null && (decryptor = this.copyForDecryption()) != null) {
            return new Pair((Object)decryptor, (Object)cryptogram);
        }
        return null;
    }

    public native byte[] decryptResponse(ECIESCryptogram var1);

    static {
        System.loadLibrary("PowerAuth2Module");
    }
}

