/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Pair;
import io.getlime.security.powerauth.core.ECIESCryptogram;
import io.getlime.security.powerauth.core.ECIESEncryptor;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.keychain.PA2Keychain;
import io.getlime.security.powerauth.networking.client.PA2Client;
import io.getlime.security.powerauth.networking.interfaces.INetworkResponseListener;
import io.getlime.security.powerauth.networking.response.IGetTokenListener;
import io.getlime.security.powerauth.networking.response.IRemoveTokenListener;
import io.getlime.security.powerauth.rest.api.model.entity.TokenResponsePayload;
import io.getlime.security.powerauth.rest.api.model.request.TokenCreateRequest;
import io.getlime.security.powerauth.rest.api.model.request.TokenRemoveRequest;
import io.getlime.security.powerauth.rest.api.model.response.TokenCreateResponse;
import io.getlime.security.powerauth.rest.api.model.response.TokenRemoveResponse;
import io.getlime.security.powerauth.sdk.PowerAuthAuthentication;
import io.getlime.security.powerauth.sdk.PowerAuthSDK;
import io.getlime.security.powerauth.sdk.PowerAuthToken;
import io.getlime.security.powerauth.sdk.impl.PowerAuthAuthorizationHttpHeader;
import io.getlime.security.powerauth.sdk.impl.PowerAuthPrivateTokenData;
import java.util.HashMap;
import java.util.HashSet;

public class PowerAuthTokenStore {
    private final PowerAuthSDK sdk;
    private final PA2Keychain keychain;
    private final PA2Client httpClient;
    private final HashMap<String, PowerAuthPrivateTokenData> localTokens;
    private final ECIESEncryptor encryptor;
    private final String keychainKeyPrefix;
    private static final String TOKENS_KEY_PREFIX = "powerAuthToken";
    private static final String TOKENS_INDEX_ENTRY = "$$index$$";

    public PowerAuthTokenStore(@NonNull PowerAuthSDK sdk, @NonNull PA2Keychain keychain, @NonNull PA2Client httpClient) {
        this.sdk = sdk;
        this.keychain = keychain;
        this.httpClient = httpClient;
        this.localTokens = new HashMap();
        this.encryptor = new ECIESEncryptor(httpClient.getConfiguration().getMasterServerPublicKey(), null);
        this.keychainKeyPrefix = "powerAuthToken__" + sdk.getConfiguration().getInstanceId() + "__";
    }

    public synchronized boolean canRequestForAccessToken() {
        return this.sdk != null && this.sdk.hasValidActivation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AsyncTask requestAccessToken(final @NonNull Context context, final @NonNull String tokenName, @NonNull PowerAuthAuthentication authentication, final @NonNull IGetTokenListener listener) {
        PowerAuthErrorException error = null;
        PowerAuthPrivateTokenData tokenData = null;
        PowerAuthTokenStore powerAuthTokenStore = this;
        synchronized (powerAuthTokenStore) {
            if (this.canRequestForAccessToken()) {
                tokenData = this.getTokenData(context, tokenName);
            } else {
                error = new PowerAuthErrorException(5);
            }
        }
        if (error != null) {
            listener.onGetTokenFailed(error);
            return null;
        }
        if (tokenData != null) {
            listener.onGetTokenSucceeded(new PowerAuthToken(this, tokenData));
            return null;
        }
        Pair<ECIESEncryptor, ECIESCryptogram> pair = this.encryptor.encryptRequestSynchronized(null);
        if (pair == null) {
            listener.onGetTokenFailed(new PowerAuthErrorException(14));
            return null;
        }
        final ECIESEncryptor decryptor = (ECIESEncryptor)pair.first;
        ECIESCryptogram cryptogram = (ECIESCryptogram)pair.second;
        TokenCreateRequest request = new TokenCreateRequest();
        request.setEphemeralPublicKey(cryptogram.getKeyBase64());
        Pair<byte[], String> postData = this.httpClient.serializeRequestObject(request);
        PowerAuthAuthorizationHttpHeader authHeader = this.sdk.requestSignatureWithAuthentication(context, authentication, "POST", "/pa/token/create", (byte[])postData.first);
        if (!authHeader.isValid()) {
            listener.onGetTokenFailed(new PowerAuthErrorException(authHeader.powerAuthErrorCode));
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(authHeader.getKey(), authHeader.getValue());
        return this.httpClient.createToken(headers, request, new INetworkResponseListener<TokenCreateResponse>(){

            @Override
            public void onNetworkResponse(TokenCreateResponse tokenCreateResponse) {
                PowerAuthPrivateTokenData newTokenData = PowerAuthTokenStore.this.decryptTokenData(decryptor, tokenCreateResponse, tokenName);
                if (newTokenData != null) {
                    PowerAuthTokenStore.this.storeTokenData(context, newTokenData);
                    listener.onGetTokenSucceeded(new PowerAuthToken(PowerAuthTokenStore.this, newTokenData));
                } else {
                    listener.onGetTokenFailed(new PowerAuthErrorException(14));
                }
            }

            @Override
            public void onNetworkError(Throwable t) {
                listener.onGetTokenFailed(t);
            }
        });
    }

    @Nullable
    private PowerAuthPrivateTokenData decryptTokenData(ECIESEncryptor decryptor, TokenCreateResponse response, String tokenName) {
        ECIESCryptogram cryptogram = new ECIESCryptogram(response.getEncryptedData(), response.getMac());
        byte[] decryptedPayload = decryptor.decryptResponse(cryptogram);
        if (decryptedPayload == null) {
            return null;
        }
        TokenResponsePayload payload = this.httpClient.deserializePlainResponse(decryptedPayload, TokenResponsePayload.class);
        if (payload.getTokenId() == null || payload.getTokenSecret() == null) {
            return null;
        }
        byte[] tokenSecretBytes = Base64.decode((String)payload.getTokenSecret(), (int)2);
        PowerAuthPrivateTokenData tokenData = new PowerAuthPrivateTokenData(tokenName, payload.getTokenId(), tokenSecretBytes);
        return tokenData.hasValidData() ? tokenData : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AsyncTask removeAccessToken(final @NonNull Context context, final @NonNull String tokenName, final @NonNull IRemoveTokenListener listener) {
        PowerAuthPrivateTokenData tokenData;
        PowerAuthErrorException error = null;
        PowerAuthTokenStore powerAuthTokenStore = this;
        synchronized (powerAuthTokenStore) {
            tokenData = this.getTokenData(context, tokenName);
            if (tokenData == null) {
                error = new PowerAuthErrorException(13);
            }
        }
        if (error != null) {
            listener.onRemoveTokenFailed(error);
            return null;
        }
        TokenRemoveRequest request = new TokenRemoveRequest();
        request.setTokenId(tokenData.identifier);
        Pair<byte[], String> postData = this.httpClient.serializeRequestObject(request);
        PowerAuthAuthentication authentication = new PowerAuthAuthentication();
        authentication.usePossession = true;
        PowerAuthAuthorizationHttpHeader authHeader = this.sdk.requestSignatureWithAuthentication(context, authentication, "POST", "/pa/token/remove", (byte[])postData.first);
        if (!authHeader.isValid()) {
            listener.onRemoveTokenFailed(new PowerAuthErrorException(authHeader.powerAuthErrorCode));
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(authHeader.getKey(), authHeader.getValue());
        return this.httpClient.removeToken(headers, request, new INetworkResponseListener<TokenRemoveResponse>(){

            @Override
            public void onNetworkResponse(TokenRemoveResponse tokenRemoveResponse) {
                PowerAuthTokenStore.this.removeLocalToken(context, tokenName);
                listener.onRemoveTokenSucceeded();
            }

            @Override
            public void onNetworkError(Throwable t) {
                listener.onRemoveTokenFailed(t);
            }
        });
    }

    public synchronized boolean hasLocalToken(@NonNull Context context, @NonNull String tokenName) {
        return this.getTokenData(context, tokenName) != null;
    }

    public synchronized void removeLocalToken(@NonNull Context context, @NonNull String tokenName) {
        String identifier = this.getLocalIdentifier(tokenName);
        this.localTokens.remove(identifier);
        this.keychain.removeDataForKey(context, identifier);
        HashSet<String> allIdentifiers = this.loadTokensIndex(context);
        allIdentifiers.remove(identifier);
        this.saveTokensIndex(context, allIdentifiers);
    }

    public synchronized void removeAllLocalTokens(@NonNull Context context) {
        this.clearTokensIndex(context);
        this.localTokens.clear();
    }

    @Nullable
    private PowerAuthPrivateTokenData getTokenData(@NonNull Context context, @NonNull String tokenName) {
        byte[] tokenBytes;
        String identifier = this.getLocalIdentifier(tokenName);
        PowerAuthPrivateTokenData tokenData = this.localTokens.get(identifier);
        if (tokenData == null && (tokenBytes = this.keychain.dataForKey(context, identifier)) != null && (tokenData = PowerAuthPrivateTokenData.deserializeWithData(tokenBytes)) != null) {
            this.localTokens.put(identifier, tokenData);
        }
        return tokenData;
    }

    private synchronized void storeTokenData(@NonNull Context context, @NonNull PowerAuthPrivateTokenData tokenData) {
        if (!this.canRequestForAccessToken()) {
            return;
        }
        String identifier = this.getLocalIdentifier(tokenData.name);
        this.localTokens.put(identifier, tokenData);
        this.keychain.putDataForKey(context, tokenData.getSerializedData(), identifier);
        HashSet<String> index = this.loadTokensIndex(context);
        index.add(identifier);
        this.saveTokensIndex(context, index);
    }

    @NonNull
    private String getLocalIdentifier(@NonNull String tokenName) {
        return this.keychainKeyPrefix + Base64.encodeToString((byte[])tokenName.getBytes(), (int)2);
    }

    private boolean isValidLocalIdentifier(@NonNull String identifier) {
        return identifier.startsWith(this.keychainKeyPrefix);
    }

    private final String getIndexKey() {
        return this.keychainKeyPrefix + TOKENS_INDEX_ENTRY;
    }

    private void saveTokensIndex(@NonNull Context context, @NonNull HashSet<String> index) {
        String joinedIdentifiers = TextUtils.join((CharSequence)"\n", (Object[])index.toArray());
        this.keychain.putStringForKey(context, joinedIdentifiers, this.getIndexKey());
    }

    private HashSet<String> loadTokensIndex(@NonNull Context context) {
        HashSet<String> index = new HashSet<String>();
        String joinedIdentifiers = this.keychain.stringForKey(context, this.getIndexKey());
        if (joinedIdentifiers != null) {
            String[] tokenIdentifiers;
            for (String identifier : tokenIdentifiers = joinedIdentifiers.split("\\n")) {
                if (!this.isValidLocalIdentifier(identifier)) continue;
                index.add(identifier);
            }
        }
        return index;
    }

    private void clearTokensIndex(@NonNull Context context) {
        HashSet<String> identifiers = this.loadTokensIndex(context);
        for (String id2 : identifiers) {
            this.keychain.removeDataForKey(context, id2);
        }
        this.keychain.removeDataForKey(context, this.getIndexKey());
    }
}

