/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.getlime.security.powerauth.networking.response.IFetchKeysStrategy;
import io.getlime.security.powerauth.sdk.impl.DefaultFetchKeysStrategy;

public class PowerAuthConfiguration {
    private String instanceId;
    private String baseEndpointUrl;
    private String appKey;
    private String appSecret;
    private String masterServerPublicKey;
    private byte[] externalEncryptionKey;
    private IFetchKeysStrategy fetchKeysStrategy;

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getBaseEndpointUrl() {
        return this.baseEndpointUrl;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getMasterServerPublicKey() {
        return this.masterServerPublicKey;
    }

    public byte[] getExternalEncryptionKey() {
        return this.externalEncryptionKey;
    }

    public IFetchKeysStrategy getFetchKeysStrategy() {
        return this.fetchKeysStrategy;
    }

    public boolean validateConfiguration() {
        boolean result = this.appKey != null;
        result = result && this.appSecret != null;
        result = result && this.masterServerPublicKey != null;
        result = result && this.baseEndpointUrl != null;
        return result;
    }

    static /* synthetic */ byte[] access$502(PowerAuthConfiguration x0, byte[] x1) {
        x0.externalEncryptionKey = x1;
        return x1;
    }

    public static class Builder {
        private final String instanceId;
        private final String baseEndpointUrl;
        private String appKey;
        private String appSecret;
        private String masterServerPublicKey;
        private IFetchKeysStrategy fetchKeysStrategy;
        private byte[] externalEncryptionKey = null;

        public Builder(@Nullable String instanceId, @NonNull String baseEndpointUrl, @NonNull String appKey, @NonNull String appSecret, @NonNull String masterServerPublicKey) {
            this(instanceId, baseEndpointUrl, appKey, appSecret, masterServerPublicKey, new DefaultFetchKeysStrategy());
        }

        public Builder(@Nullable String instanceId, @NonNull String baseEndpointUrl, @NonNull String appKey, @NonNull String appSecret, @NonNull String masterServerPublicKey, @NonNull IFetchKeysStrategy fetchKeysStrategy) {
            this.instanceId = instanceId;
            this.appKey = appKey;
            this.appSecret = appSecret;
            this.masterServerPublicKey = masterServerPublicKey;
            this.fetchKeysStrategy = fetchKeysStrategy;
            this.baseEndpointUrl = baseEndpointUrl.endsWith("/") ? baseEndpointUrl.substring(0, baseEndpointUrl.length() - 1) : baseEndpointUrl;
        }

        public Builder externalEncryptionKey(byte[] externalEncryptionKey) {
            this.externalEncryptionKey = externalEncryptionKey;
            return this;
        }

        public PowerAuthConfiguration build() {
            PowerAuthConfiguration powerAuthConfiguration = new PowerAuthConfiguration();
            powerAuthConfiguration.instanceId = this.instanceId;
            powerAuthConfiguration.baseEndpointUrl = this.baseEndpointUrl;
            powerAuthConfiguration.appKey = this.appKey;
            powerAuthConfiguration.appSecret = this.appSecret;
            powerAuthConfiguration.masterServerPublicKey = this.masterServerPublicKey;
            PowerAuthConfiguration.access$502(powerAuthConfiguration, this.externalEncryptionKey);
            powerAuthConfiguration.fetchKeysStrategy = this.fetchKeysStrategy;
            return powerAuthConfiguration;
        }
    }
}

