/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.util.otp;

import io.getlime.security.powerauth.util.otp.Otp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OtpUtil {
    private static final String ACT_CODE_PATTERN = "^([A-Z2-7]{5}-[A-Z2-7]{5})-([A-Z2-7]{5}-[A-Z2-7]{5})(#([A-Za-z0-9+=]*))?$";

    public static Otp parseFromActivationCode(String activationCode) {
        Pattern pattern = Pattern.compile(ACT_CODE_PATTERN);
        Matcher matcher = pattern.matcher(activationCode.trim());
        if (matcher.find()) {
            try {
                String activationIdShort = matcher.group(1);
                String activationOtp = matcher.group(2);
                String activationSignature = matcher.group(3);
                return new Otp(activationIdShort, activationOtp, activationSignature);
            }
            catch (IllegalStateException | IndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }
}

