/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.domain;

import java.util.Objects;

public enum KeyType {
    RSA("RSA"),
    RSASSA_PSS("RSASSA-PSS"),
    EC("EC"),
    OKP("EdDSA");

    private final String algorithm;

    private KeyType(String algorithm) {
        this.algorithm = algorithm;
    }

    public static KeyType getKeyTypeFromOid(String oid) {
        Objects.requireNonNull(oid);
        return switch (oid) {
            case "1.2.840.10045.2.1" -> EC;
            case "1.3.101.113", "1.3.101.112" -> OKP;
            case "1.2.840.113549.1.1.1" -> RSA;
            case "1.2.840.113549.1.1.10" -> RSASSA_PSS;
            default -> null;
        };
    }

    public String getAlgorithm() {
        return this.algorithm;
    }
}

