/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.rsa;

import io.fusionauth.jwt.InvalidJWTSignatureException;
import io.fusionauth.jwt.InvalidKeyLengthException;
import io.fusionauth.jwt.InvalidKeyTypeException;
import io.fusionauth.jwt.JWTVerifierException;
import io.fusionauth.jwt.MissingPublicKeyException;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.pem.domain.PEM;
import io.fusionauth.security.CryptoProvider;
import io.fusionauth.security.DefaultCryptoProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Objects;

public class RSAPSSVerifier
implements Verifier {
    private final RSAPublicKey publicKey;
    private final CryptoProvider cryptoProvider;

    private RSAPSSVerifier(PublicKey publicKey, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(cryptoProvider);
        this.cryptoProvider = cryptoProvider;
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyTypeException("Expecting a public key of type [RSAPublicKey], but found [" + publicKey.getClass().getSimpleName() + "].");
        }
        this.publicKey = (RSAPublicKey)publicKey;
        this.assertValidKeyLength();
    }

    private RSAPSSVerifier(String publicKey, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(cryptoProvider);
        this.cryptoProvider = cryptoProvider;
        PEM pem = PEM.decode(publicKey);
        if (pem.publicKey == null) {
            throw new MissingPublicKeyException("The provided PEM encoded string did not contain a public key.");
        }
        if (!(pem.publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyTypeException("Expecting a public key of type [RSAPublicKey], but found [" + pem.publicKey.getClass().getSimpleName() + "].");
        }
        this.publicKey = (RSAPublicKey)pem.getPublicKey();
        this.assertValidKeyLength();
    }

    public static RSAPSSVerifier newVerifier(PublicKey publicKey) {
        return new RSAPSSVerifier(publicKey, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSVerifier newVerifier(PublicKey publicKey, CryptoProvider cryptoProvider) {
        return new RSAPSSVerifier(publicKey, cryptoProvider);
    }

    public static RSAPSSVerifier newVerifier(String publicKey) {
        return new RSAPSSVerifier(publicKey, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSVerifier newVerifier(String publicKey, CryptoProvider cryptoProvider) {
        return new RSAPSSVerifier(publicKey, cryptoProvider);
    }

    public static RSAPSSVerifier newVerifier(Path path) {
        return RSAPSSVerifier.newVerifier(path, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSVerifier newVerifier(Path path, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(path);
        try {
            return new RSAPSSVerifier(new String(Files.readAllBytes(path)), cryptoProvider);
        }
        catch (IOException e) {
            throw new JWTVerifierException("Unable to read the file from path [" + path.toAbsolutePath().toString() + "]", e);
        }
    }

    public static RSAPSSVerifier newVerifier(byte[] bytes) {
        Objects.requireNonNull(bytes);
        return new RSAPSSVerifier(new String(bytes), (CryptoProvider)new DefaultCryptoProvider());
    }

    @Override
    public boolean canVerify(Algorithm algorithm) {
        switch (algorithm) {
            case PS256: 
            case PS384: 
            case PS512: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void verify(Algorithm algorithm, byte[] message, byte[] signature) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(message);
        Objects.requireNonNull(signature);
        try {
            Signature verifier = this.cryptoProvider.getSignatureInstance("RSASSA-PSS");
            verifier.setParameter(new PSSParameterSpec(algorithm.getName(), "MGF1", new MGF1ParameterSpec(algorithm.getName()), algorithm.getSaltLength(), 1));
            verifier.initVerify(this.publicKey);
            verifier.update(message);
            if (!verifier.verify(signature)) {
                throw new InvalidJWTSignatureException();
            }
        }
        catch (SecurityException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTVerifierException("An unexpected exception occurred when attempting to verify the JWT", e);
        }
    }

    private void assertValidKeyLength() {
        int keyLength = this.publicKey.getModulus().bitLength();
        if (keyLength < 2048) {
            throw new InvalidKeyLengthException("Key length of [" + keyLength + "] is less than the required key length of 2048 bits.");
        }
    }
}

