/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwks;

import com.fasterxml.jackson.databind.JsonNode;
import io.fusionauth.jwks.domain.JSONWebKey;
import io.fusionauth.jwt.json.Mapper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class JSONWebKeySetHelper {
    public static List<JSONWebKey> retrieveKeysFromIssuer(String issuer) {
        Objects.requireNonNull(issuer);
        if (issuer.endsWith("/")) {
            issuer = issuer.substring(0, issuer.length() - 1);
        }
        return JSONWebKeySetHelper.retrieveKeysFromWellKnownConfiguration(issuer + "/.well-known/openid-configuration");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T get(HttpURLConnection urlConnection, Function<InputStream, T> consumer) {
        int status;
        String endpoint = urlConnection.getURL().toString();
        try {
            urlConnection.setRequestMethod("GET");
            urlConnection.connect();
        }
        catch (Exception e) {
            throw new JSONWebKeySetException("Failed to connect to [" + endpoint + "].", e);
        }
        try {
            status = urlConnection.getResponseCode();
        }
        catch (Exception e) {
            throw new JSONWebKeySetException("Failed to make a request to [" + endpoint + "].", e);
        }
        if (status < 200) throw new JSONWebKeySetException("Failed to make a request to [" + endpoint + "], a status code of [" + status + "] was returned.");
        if (status > 299) {
            throw new JSONWebKeySetException("Failed to make a request to [" + endpoint + "], a status code of [" + status + "] was returned.");
        }
        try (BufferedInputStream is = new BufferedInputStream(urlConnection.getInputStream());){
            InputStream inputStream = consumer.apply(is);
            return (T)inputStream;
        }
        catch (Exception e) {
            throw new JSONWebKeySetException("Failed to parse the response as JSON from [" + endpoint + "].", e);
        }
    }

    public static List<JSONWebKey> retrieveKeysFromWellKnownConfiguration(HttpURLConnection httpURLConnection) {
        return JSONWebKeySetHelper.get(httpURLConnection, is -> {
            JsonNode response = Mapper.deserialize(is, JsonNode.class);
            JsonNode jwksURI = response.at("/jwks_uri");
            if (jwksURI.isMissingNode()) {
                String endpoint = httpURLConnection.getURL().toString();
                throw new JSONWebKeySetException("The well-known endpoint [" + endpoint + "] has not defined a JSON Web Key Set endpoint. Missing the [jwks_uri] property.");
            }
            return JSONWebKeySetHelper.retrieveKeysFromJWKS(jwksURI.asText());
        });
    }

    public static List<JSONWebKey> retrieveKeysFromWellKnownConfiguration(String endpoint) {
        return JSONWebKeySetHelper.retrieveKeysFromWellKnownConfiguration(JSONWebKeySetHelper.buildURLConnection(endpoint));
    }

    public static List<JSONWebKey> retrieveKeysFromJWKS(String endpoint) {
        return JSONWebKeySetHelper.retrieveKeysFromJWKS(JSONWebKeySetHelper.buildURLConnection(endpoint));
    }

    public static List<JSONWebKey> retrieveKeysFromJWKS(HttpURLConnection httpURLConnection) {
        return JSONWebKeySetHelper.get(httpURLConnection, is -> Mapper.deserialize((InputStream)is, JSONWebKeySetResponse.class).keys);
    }

    private static HttpURLConnection buildURLConnection(String endpoint) {
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(endpoint).openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setConnectTimeout(3000);
            urlConnection.setReadTimeout(2000);
            urlConnection.addRequestProperty("User-Agent", "fusionauth-jwt (https://github.com/FusionAuth/fusionauth-jwt)");
            return urlConnection;
        }
        catch (IOException e) {
            throw new JSONWebKeySetException("Failed to build connection to [" + endpoint + "].", e);
        }
    }

    private static class JSONWebKeySetResponse {
        public List<JSONWebKey> keys;

        private JSONWebKeySetResponse() {
        }
    }

    public static class JSONWebKeySetException
    extends RuntimeException {
        public JSONWebKeySetException(String message) {
            super(message);
        }

        public JSONWebKeySetException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

