/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.hmac;

import io.fusionauth.jwt.JWTSigningException;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.domain.Algorithm;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACSigner
implements Signer {
    private final Algorithm algorithm;
    private final String kid;
    private byte[] secret;

    private HMACSigner(Algorithm algorithm, String secret, String kid) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(secret);
        this.algorithm = algorithm;
        this.kid = kid;
        this.secret = secret.getBytes(StandardCharsets.UTF_8);
    }

    public static HMACSigner newSHA256Signer(String secret, String kid) {
        return new HMACSigner(Algorithm.HS256, secret, kid);
    }

    public static HMACSigner newSHA256Signer(String secret) {
        return new HMACSigner(Algorithm.HS256, secret, null);
    }

    public static HMACSigner newSHA384Signer(String secret, String kid) {
        return new HMACSigner(Algorithm.HS384, secret, kid);
    }

    public static HMACSigner newSHA384Signer(String secret) {
        return new HMACSigner(Algorithm.HS384, secret, null);
    }

    public static HMACSigner newSHA512Signer(String secret, String kid) {
        return new HMACSigner(Algorithm.HS512, secret, kid);
    }

    public static HMACSigner newSHA512Signer(String secret) {
        return new HMACSigner(Algorithm.HS512, secret, null);
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getKid() {
        return this.kid;
    }

    @Override
    public byte[] sign(String message) {
        Objects.requireNonNull(message);
        try {
            Mac mac = Mac.getInstance(this.algorithm.getName());
            mac.init(new SecretKeySpec(this.secret, this.algorithm.getName()));
            return mac.doFinal(message.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new JWTSigningException("An unexpected exception occurred when attempting to sign the JWT", e);
        }
    }
}

