/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.pem;

import io.fusionauth.der.DerInputStream;
import io.fusionauth.der.DerOutputStream;
import io.fusionauth.der.DerValue;
import io.fusionauth.der.ObjectIdentifier;
import io.fusionauth.pem.PEMEncoderException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.util.Base64;

public class PEMEncoder {
    private static final Base64.Encoder Base64_MIME_Encoder = Base64.getMimeEncoder(64, new byte[]{10});

    public String encode(PrivateKey privateKey, PublicKey publicKey) {
        if (privateKey == null && publicKey == null) {
            throw new PEMEncoderException(new InvalidParameterException("At least one key must be provided, they may not both be null"));
        }
        Key key = privateKey == null ? publicKey : privateKey;
        StringBuilder sb = new StringBuilder();
        this.addOpeningTag(key, sb);
        try {
            if (key.getFormat().equals("PKCS#8") && key instanceof ECPrivateKey && publicKey != null) {
                byte[] encodedKey = key.getEncoded();
                DerValue[] sequence = new DerInputStream(encodedKey).getSequence();
                ObjectIdentifier algorithmOID = sequence[1].getOID();
                ObjectIdentifier curveOID = sequence[1].getOID();
                DerValue[] nested = new DerInputStream(sequence[2]).getSequence();
                if (nested.length == 2) {
                    DerValue[] publicSequence = new DerInputStream(publicKey.getEncoded()).getSequence();
                    byte[] nestedPrivateKeyBytes = new DerOutputStream().writeValue(new DerValue(48, new DerOutputStream().writeValue(new DerValue(nested[0].getBigInteger())).writeValue(new DerValue(4, nested[1].toByteArray())).writeValue(new DerValue(161, new DerOutputStream().writeValue(new DerValue(3, publicSequence[1].toByteArray())))))).toByteArray();
                    DerOutputStream pkcs_8 = new DerOutputStream().writeValue(new DerValue(48, new DerOutputStream().writeValue(new DerValue(BigInteger.valueOf(0L))).writeValue(new DerValue(48, new DerOutputStream().writeValue(new DerValue(6, algorithmOID.value)).writeValue(new DerValue(6, curveOID.value)))).writeValue(new DerValue(4, nestedPrivateKeyBytes))));
                    sb.append(Base64_MIME_Encoder.encodeToString(pkcs_8.toByteArray()));
                }
            } else {
                sb.append(Base64_MIME_Encoder.encodeToString(key.getEncoded()));
            }
        }
        catch (IOException e) {
            throw new PEMEncoderException(e);
        }
        this.addClosingTag(key, sb);
        return sb.toString();
    }

    public String encode(Key key) {
        if (key instanceof PrivateKey) {
            return this.encode((PrivateKey)key, null);
        }
        if (key instanceof PublicKey) {
            return this.encode(null, (PublicKey)key);
        }
        throw new PEMEncoderException(new InvalidParameterException("Unexpected key type. Expecting instance of [PrivateKey | PublicKey], found [" + key.getClass().getCanonicalName() + "]"));
    }

    private void addClosingTag(Key key, StringBuilder sb) {
        sb.append("\n");
        if (key instanceof PrivateKey) {
            if (key.getFormat().equals("PKCS#1")) {
                sb.append("-----END RSA PRIVATE KEY-----").append("\n");
            } else if (key.getFormat().equals("PKCS#8")) {
                sb.append("-----END PRIVATE KEY-----").append("\n");
            }
        } else {
            sb.append("-----END PUBLIC KEY-----").append("\n");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addOpeningTag(Key key, StringBuilder sb) {
        String format = key.getFormat();
        if (key instanceof PrivateKey) {
            if (format.equals("PKCS#1")) {
                sb.append("-----BEGIN RSA PRIVATE KEY-----").append("\n");
                return;
            } else {
                if (!format.equals("PKCS#8")) throw new PEMEncoderException(new InvalidParameterException("Unexpected Private Key format, expecting PKCS#1 or PKCS#8 but found " + format + "."));
                sb.append("-----BEGIN PRIVATE KEY-----").append("\n");
            }
            return;
        } else {
            if (!format.equals("X.509")) throw new PEMEncoderException(new InvalidParameterException("Unexpected Public Key format, expecting X.509 but found " + format + "."));
            sb.append("-----BEGIN PUBLIC KEY-----").append("\n");
        }
    }
}

