/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.spring.okhttp.metrics;

import io.freefair.spring.okhttp.metrics.OkHttpMetricsProperties;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.okhttp3.OkHttpMetricsEventListener;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnProperty(value={"okhttp.metrics.enabled"}, matchIfMissing=true, havingValue="true")
@ConditionalOnBean(value={MeterRegistry.class})
@ConditionalOnClass(value={MeterRegistry.class, OkHttpMetricsEventListener.class, OkHttpClient.class})
@EnableConfigurationProperties(value={OkHttpMetricsProperties.class})
public class OkHttpMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OkHttpMetricsEventListener okHttpMetricsEventListener(MeterRegistry meterRegistry, OkHttpMetricsProperties properties) {
        Map<String, String> tags;
        OkHttpMetricsEventListener.Builder builder = OkHttpMetricsEventListener.builder((MeterRegistry)meterRegistry, (String)properties.getName()).includeHostTag(properties.isIncludeHostTag());
        List<String> requestTagKeys = properties.getRequestTagKeys();
        if (!CollectionUtils.isEmpty(requestTagKeys)) {
            builder = builder.requestTagKeys(requestTagKeys);
        }
        if (!CollectionUtils.isEmpty(tags = properties.getTags())) {
            builder = builder.tags(this.getTags(tags));
        }
        return builder.build();
    }

    private List<Tag> getTags(Map<String, String> tags) {
        return tags.entrySet().stream().map(entry -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList());
    }
}

