/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.spring.okhttp.logging;

import io.freefair.spring.okhttp.ApplicationInterceptor;
import io.freefair.spring.okhttp.OkHttp3AutoConfiguration;
import io.freefair.spring.okhttp.logging.OkHttp3LoggingInterceptorProperties;
import okhttp3.logging.HttpLoggingInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={HttpLoggingInterceptor.class})
@AutoConfigureBefore(value={OkHttp3AutoConfiguration.class})
@EnableConfigurationProperties(value={OkHttp3LoggingInterceptorProperties.class})
public class OkHttp3LoggingInterceptorAutoConfiguration {
    @Autowired
    private OkHttp3LoggingInterceptorProperties properties;

    @Bean
    @ApplicationInterceptor
    @ConditionalOnMissingBean
    public HttpLoggingInterceptor okHttp3LoggingInterceptor(ObjectProvider<HttpLoggingInterceptor.Logger> logger) {
        HttpLoggingInterceptor httpLoggingInterceptor = logger.getIfAvailable() != null ? new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)logger.getIfAvailable()) : new HttpLoggingInterceptor();
        httpLoggingInterceptor.level(this.properties.getLevel());
        return httpLoggingInterceptor;
    }
}

