/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.javadoc;

import io.freefair.gradle.plugins.maven.javadoc.JavadocLinkProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.gradle.api.JavaVersion;
import org.gradle.api.NonNullApi;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavadocTool;

@NonNullApi
public class ResolveJavadocLinks {
    private final OkHttpClient okHttpClient;
    private final ServiceLoader<JavadocLinkProvider> javadocLinkProviders;
    private Javadoc javadoc;
    private Logger logger;

    public ResolveJavadocLinks(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        this.javadocLinkProviders = ServiceLoader.load(JavadocLinkProvider.class, this.getClass().getClassLoader());
    }

    public void resolveLinks(Javadoc javadoc, Configuration classpath) {
        this.logger = javadoc.getLogger();
        this.javadoc = javadoc;
        this.addLink(this.getJavaSeLink());
        classpath.getResolvedConfiguration().getResolvedArtifacts().stream().map(resolvedArtifact -> resolvedArtifact.getId().getComponentIdentifier()).filter(ModuleComponentIdentifier.class::isInstance).map(ModuleComponentIdentifier.class::cast).map(moduleComponentIdentifier -> {
            String version;
            String artifact;
            String group = moduleComponentIdentifier.getGroup();
            String wellKnownLink = this.findWellKnownLink(group, artifact = moduleComponentIdentifier.getModule(), version = moduleComponentIdentifier.getVersion());
            if (wellKnownLink != null) {
                javadoc.getLogger().info("Using well known link '{}' for '{}:{}:{}'", new Object[]{wellKnownLink, group, artifact, version});
                return wellKnownLink;
            }
            String javadocIoLink = String.format("https://www.javadoc.io/doc/%s/%s/%s/", group, artifact, version);
            if (this.checkLink(javadocIoLink)) {
                javadoc.getLogger().info("Using javadoc.io link for '{}:{}:{}'", new Object[]{group, artifact, version});
                return javadocIoLink;
            }
            return null;
        }).filter(Objects::nonNull).forEach(this::addLink);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkLink(String link) {
        IOException exception = null;
        Iterator<String> iterator = Arrays.asList("element-list", "package-list").iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (exception == null) return false;
                this.logger.warn("Failed to check link {}", (Object)link, exception);
                return false;
            }
            String file = iterator.next();
            Request request = new Request.Builder().url(link + file).get().build();
            try {
                Response response = this.okHttpClient.newCall(request).execute();
                Throwable throwable = null;
                try {
                    if (!response.isSuccessful()) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (IOException e) {
                this.logger.info("Failed to access {}", (Object)request.url(), (Object)e);
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
                continue;
            }
            break;
        }
    }

    @Nullable
    private String findWellKnownLink(String group, String artifact, String version) {
        this.javadocLinkProviders.reload();
        for (JavadocLinkProvider javadocLinkProvider : this.javadocLinkProviders) {
            this.logger.info("{}", javadocLinkProvider.getClass());
            String javadocLink = javadocLinkProvider.getJavadocLink(group, artifact, version);
            if (javadocLink == null) continue;
            return javadocLink;
        }
        if (group.equals("javax") && artifact.equals("javaee-api") && version.matches("[567]\\..*")) {
            return "https://docs.oracle.com/javaee/" + version.substring(0, 1) + "/api/";
        }
        if (group.equals("org.hibernate") && artifact.equals("hibernate-core")) {
            return "https://docs.jboss.org/hibernate/orm/" + version.substring(0, 3) + "/javadocs/";
        }
        if ((group.equals("org.hibernate") || group.equals("org.hibernate.validator")) && artifact.equals("hibernate-validator")) {
            return "https://docs.jboss.org/hibernate/validator/" + version.substring(0, 3) + "/api/";
        }
        if (group.equals("org.primefaces") && artifact.equals("primefaces")) {
            return "https://www.primefaces.org/docs/api/" + version + "/";
        }
        if (group.equals("org.eclipse.jetty")) {
            return "https://www.eclipse.org/jetty/javadoc/" + version + "/";
        }
        if (group.equals("org.ow2.asm")) {
            return "https://asm.ow2.io/javadoc/";
        }
        if (group.equals("org.joinfaces")) {
            return "https://docs.joinfaces.org/" + version + "/api/";
        }
        if (group.equals("org.projectlombok")) {
            return "https://projectlombok.org/api/";
        }
        if (group.equals("org.jetbrains.kotlin")) {
            return "https://kotlinlang.org/api/latest/jvm/stdlib/";
        }
        return null;
    }

    private String getJavaSeLink() {
        JavaVersion javaVersion = JavaVersion.current();
        Property javadocTool = this.javadoc.getJavadocTool();
        if (javadocTool.isPresent()) {
            JavaLanguageVersion languageVersion = ((JavadocTool)javadocTool.get()).getMetadata().getLanguageVersion();
            javaVersion = JavaVersion.toVersion((Object)languageVersion.asInt());
        }
        if (javaVersion.isJava11Compatible()) {
            return "https://docs.oracle.com/en/java/javase/" + javaVersion.getMajorVersion() + "/docs/api/";
        }
        return "https://docs.oracle.com/javase/" + javaVersion.getMajorVersion() + "/docs/api/";
    }

    private void addLink(String link) {
        MinimalJavadocOptions options = this.javadoc.getOptions();
        if (options instanceof StandardJavadocDocletOptions) {
            StandardJavadocDocletOptions docletOptions = (StandardJavadocDocletOptions)options;
            List links = docletOptions.getLinks();
            if (links == null || !links.contains(link)) {
                this.logger.debug("Adding '{}' to {}", (Object)link, (Object)this.javadoc);
                docletOptions.links(new String[]{link});
            } else {
                this.logger.info("Not adding '{}' to {} because it's already present", (Object)link, (Object)this.javadoc);
            }
        }
    }
}

