/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.central;

import io.freefair.gradle.plugins.maven.central.ValidateMavenPom;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.base.plugins.LifecycleBasePlugin;

public class ValidatePomsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        TaskProvider validateAll = project.getTasks().register("validatePomFiles", t -> t.setGroup("verification"));
        project.getTasks().withType(GenerateMavenPom.class, generateMavenPom -> {
            String checkTaskName = generateMavenPom.getName().startsWith("generate") ? "validate" + generateMavenPom.getName().substring(8) : "validate" + generateMavenPom.getName();
            TaskProvider validateMavenPom = project.getTasks().register(checkTaskName, ValidateMavenPom.class, t -> {
                t.setGroup("verification");
                String description = generateMavenPom.getDescription();
                if (description != null) {
                    t.setDescription(description.replace("Generates", "Validates"));
                }
            });
            validateAll.configure(all -> all.dependsOn(new Object[]{validateMavenPom}));
            project.getPlugins().withType(LifecycleBasePlugin.class, lbp -> project.getTasks().named("check").configure(check -> check.dependsOn(new Object[]{validateMavenPom})));
            project.afterEvaluate(p -> validateMavenPom.configure(v -> {
                v.dependsOn(new Object[]{generateMavenPom});
                v.getPomFile().set(generateMavenPom.getDestination());
            }));
        });
    }
}

