/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.war;

import io.freefair.gradle.plugins.maven.war.WarArchiveClassesConvention;
import java.io.File;
import java.util.Collections;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.War;

public class WarArchiveClassesPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getTasks().withType(War.class, war -> {
            Property archiveClasses = project.getObjects().property(Boolean.class).convention((Object)false);
            war.getExtensions().add("archiveClasses", (Object)archiveClasses);
            WarArchiveClassesConvention archiveClassesConvention = new WarArchiveClassesConvention((Property<Boolean>)archiveClasses);
            war.getConvention().getPlugins().put("archiveClasses", archiveClassesConvention);
            Jar warClassesJar = (Jar)project.getTasks().create(war.getName() + "ClassesJar", Jar.class);
            warClassesJar.getArchiveBaseName().convention((Provider)war.getArchiveBaseName());
            warClassesJar.getArchiveAppendix().convention((Provider)war.getArchiveAppendix());
            warClassesJar.getArchiveVersion().convention((Provider)war.getArchiveVersion());
            warClassesJar.getArchiveClassifier().convention((Provider)war.getArchiveClassifier());
            project.afterEvaluate(p -> {
                warClassesJar.setEnabled(((Boolean)archiveClasses.get()).booleanValue());
                if (((Boolean)archiveClasses.get()).booleanValue()) {
                    FileCollection warClasspath = war.getClasspath();
                    warClassesJar.from(new Object[]{warClasspath != null ? warClasspath.filter(File::isDirectory) : Collections.emptyList()});
                    war.setClasspath(warClasspath == null ? null : warClasspath.filter(File::isFile).plus((FileCollection)project.files(new Object[]{warClassesJar})));
                }
            });
        });
    }
}

