/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.javadoc;

import io.freefair.gradle.plugins.maven.javadoc.AggregateJavadocClientPlugin;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;

public class AggregateJavadocPlugin
implements Plugin<Project> {
    private TaskProvider<Javadoc> aggregateJavadoc;
    private ConfigurableFileCollection aggregateClasspath;

    public void apply(final Project project) {
        this.aggregateClasspath = project.files(new Object[0]);
        this.aggregateJavadoc = project.getTasks().register("aggregateJavadoc", Javadoc.class, aggregateJavadoc -> {
            aggregateJavadoc.setGroup("documentation");
            aggregateJavadoc.getConventionMapping().map("destinationDir", (Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    File docsDir = Optional.ofNullable((JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class)).map(JavaPluginExtension::getDocsDir).map(directoryProperty -> ((Directory)directoryProperty.get()).getAsFile()).orElse(new File(project.getBuildDir(), "docs"));
                    return new File(docsDir, "aggregateJavadoc");
                }
            });
            aggregateJavadoc.setClasspath((FileCollection)this.aggregateClasspath);
        });
        project.allprojects(subproject -> subproject.afterEvaluate(this::handleSubproject));
    }

    private void handleSubproject(Project subproject) {
        subproject.getPlugins().withType(JavaPlugin.class, jp -> {
            AggregateJavadocClientPlugin clientPlugin = (AggregateJavadocClientPlugin)subproject.getPlugins().apply(AggregateJavadocClientPlugin.class);
            this.aggregateClasspath.from(new Object[]{clientPlugin.getJavadocClasspath()});
            this.aggregateJavadoc.configure(aj -> {
                SourceSet main = (SourceSet)((JavaPluginExtension)subproject.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main");
                Javadoc javadoc = (Javadoc)subproject.getTasks().named(main.getJavadocTaskName(), Javadoc.class).get();
                aj.dependsOn(new Object[]{subproject.getTasks().findByName("classes")});
                aj.source(new Object[]{javadoc.getSource()});
                StandardJavadocDocletOptions options = (StandardJavadocDocletOptions)javadoc.getOptions();
                StandardJavadocDocletOptions aggregateOptions = (StandardJavadocDocletOptions)aj.getOptions();
                options.getLinks().forEach(link -> {
                    if (!aggregateOptions.getLinks().contains(link)) {
                        aggregateOptions.getLinks().add(link);
                    }
                });
                options.getLinksOffline().forEach(link -> {
                    if (!aggregateOptions.getLinksOffline().contains(link)) {
                        aggregateOptions.getLinksOffline().add(link);
                    }
                });
                options.getJFlags().forEach(jFlag -> {
                    if (!aggregateOptions.getJFlags().contains(jFlag)) {
                        aggregateOptions.getJFlags().add(jFlag);
                    }
                });
            });
        });
    }

    @Generated
    public TaskProvider<Javadoc> getAggregateJavadoc() {
        return this.aggregateJavadoc;
    }

    @Generated
    public ConfigurableFileCollection getAggregateClasspath() {
        return this.aggregateClasspath;
    }
}

