/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.war;

import groovy.lang.Closure;
import io.freefair.gradle.plugins.maven.war.WarOverlay;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.War;

@NonNullApi
public class WarOverlayPlugin
implements Plugin<Project> {
    private Project project;

    public void apply(Project project) {
        this.project = project;
        project.getPluginManager().apply(WarPlugin.class);
        project.getTasks().withType(War.class, warTask -> {
            NamedDomainObjectContainer warOverlays = project.container(WarOverlay.class, name -> new WarOverlay(name, (War)warTask));
            warTask.getExtensions().add("overlays", (Object)warOverlays);
            Configuration warOverlayClasspath = (Configuration)project.getConfigurations().create(warTask.getName() + "OverlayClasspath");
            warTask.getExtensions().add("overlayClasspath", (Object)warOverlayClasspath);
            if (warTask.getName().equals("war")) {
                project.getConfigurations().getByName("compileClasspath").extendsFrom(new Configuration[]{warOverlayClasspath});
                project.getConfigurations().getByName("testCompile").extendsFrom(new Configuration[]{warOverlayClasspath});
            }
            project.afterEvaluate(p -> warOverlays.all(overlay -> {
                if (overlay.isEnabled()) {
                    this.configureOverlay((WarOverlay)overlay);
                } else {
                    Collection children = (Collection)overlay.getWarTask().getRootSpec().getChildren();
                    children.remove(overlay.getWarCopySpec());
                }
            }));
        });
    }

    private void configureOverlay(final WarOverlay overlay) {
        if (overlay.isDeferProvidedConfiguration()) {
            overlay.getWarTask().doFirst((Action)new Action<Task>(){

                public void execute(Task w) {
                    overlay.getWarCopySpec().exclude(element -> overlay.isProvided());
                }
            });
        } else {
            overlay.getWarCopySpec().exclude(element -> overlay.isProvided());
        }
        Object source = overlay.getSource();
        if (source instanceof AbstractArchiveTask) {
            this.configureOverlay(overlay, (AbstractArchiveTask)source);
        } else if (source instanceof Project && overlay.getConfigureClosure() == null) {
            this.configureOverlay(overlay, (Project)source);
        } else if (source instanceof File) {
            this.configureOverlay(overlay, (File)source);
        } else {
            Closure configClosure = overlay.getConfigureClosure();
            Dependency dependency = configClosure == null ? this.project.getDependencies().create(source) : this.project.getDependencies().create(source, configClosure);
            if (dependency instanceof ProjectDependency) {
                this.configureOverlay(overlay, ((ProjectDependency)dependency).getDependencyProject());
            } else if (dependency instanceof ExternalDependency) {
                this.configureOverlay(overlay, (ExternalDependency)dependency);
            } else {
                throw new GradleException("Unsupported dependency type: " + dependency.getClass().getName());
            }
        }
    }

    private void configureOverlay(WarOverlay overlay, File file) {
        this.configureOverlay(overlay, () -> this.project.zipTree((Object)file));
    }

    private void configureOverlay(WarOverlay overlay, ExternalDependency dependency) {
        War warTask = overlay.getWarTask();
        dependency.setTransitive(false);
        Configuration configuration = (Configuration)this.project.getConfigurations().create(overlay.getConfigurationName());
        configuration.setDescription(String.format("Contents of the overlay '%s' for the task '%s'.", overlay.getName(), warTask.getName()));
        configuration.getDependencies().add((Object)dependency);
        this.configureOverlay(overlay, () -> this.project.zipTree((Object)configuration.getSingleFile()));
    }

    private void configureOverlay(WarOverlay overlay, Callable<FileTree> warTree) {
        War warTask = overlay.getWarTask();
        String capitalizedWarTaskName = StringGroovyMethods.capitalize((CharSequence)warTask.getName());
        String capitalizedOverlayName = StringGroovyMethods.capitalize((CharSequence)overlay.getName());
        File destinationDir = new File(this.project.getBuildDir(), String.format("overlays/%s/%s", warTask.getName(), overlay.getName()));
        Action extractOverlay = copySpec -> {
            copySpec.into((Object)destinationDir);
            copySpec.from(new Object[]{warTree});
        };
        Sync extractOverlayTask = (Sync)this.project.getTasks().create(String.format("extract%s%sOverlay", capitalizedOverlayName, capitalizedWarTaskName), Sync.class, extractOverlay);
        overlay.getWarCopySpec().from(new Object[]{extractOverlayTask});
        if (overlay.isEnableCompilation()) {
            if (!destinationDir.exists() || this.isEmpty(destinationDir)) {
                this.project.sync(extractOverlay);
            }
            this.project.getTasks().getByName("clean").finalizedBy(new Object[]{extractOverlayTask});
            ConfigurableFileCollection classes = this.project.files(new Object[]{new File(destinationDir, "WEB-INF/classes")}).builtBy(new Object[]{extractOverlayTask});
            this.project.getDependencies().add(this.getClasspathConfigurationName(overlay), (Object)classes);
            FileTree libs = this.project.files(new Object[]{extractOverlayTask}).builtBy(new Object[]{extractOverlayTask}).getAsFileTree().matching(patternFilterable -> patternFilterable.include(new String[]{"WEB-INF/lib/**"}));
            this.project.getDependencies().add(this.getClasspathConfigurationName(overlay), (Object)libs);
        }
    }

    private boolean isEmpty(File destinationDir) {
        String[] list = destinationDir.list();
        return list == null || list.length == 0;
    }

    private void configureOverlay(WarOverlay overlay, Project otherProject) {
        this.project.evaluationDependsOn(otherProject.getPath());
        War otherWar = (War)otherProject.getTasks().getByName("war");
        this.configureOverlay(overlay, (AbstractArchiveTask)otherWar);
        if (overlay.isEnableCompilation()) {
            this.project.getDependencies().add(this.getClasspathConfigurationName(overlay), (Object)otherProject);
            otherProject.getPlugins().withType(WarOverlayPlugin.class, otherWarOverlayPlugin -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("path", otherProject.getPath());
                map.put("configuration", otherWarOverlayPlugin.getClasspathConfigurationName(otherWar));
                this.project.getDependencies().add(this.getClasspathConfigurationName(overlay), (Object)this.project.getDependencies().project(map));
            });
        }
    }

    private void configureOverlay(WarOverlay overlay, AbstractArchiveTask from) {
        overlay.getWarCopySpec().with(new CopySpec[]{from.getRootSpec()});
    }

    private String getClasspathConfigurationName(WarOverlay warOverlay) {
        return this.getClasspathConfigurationName(warOverlay.getWarTask());
    }

    private String getClasspathConfigurationName(War warTask) {
        return warTask.getName() + "OverlayClasspath";
    }
}

