/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.javadoc;

import io.freefair.gradle.plugins.maven.javadoc.AggregateJavadocPlugin;
import java.io.File;
import lombok.Generated;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;

public class JavadocJarPlugin
implements Plugin<Project> {
    private TaskProvider<Jar> javadocJar;
    private TaskProvider<Jar> aggregateJavadocJar;

    public void apply(Project project) {
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            this.javadocJar = project.getTasks().register("javadocJar", Jar.class, javadocJar -> {
                javadocJar.from(new Object[]{project.getTasks().named("javadoc")});
                javadocJar.getArchiveClassifier().set((Object)"javadoc");
                javadocJar.setDescription("Assembles a jar archive containing the javadocs.");
                javadocJar.setGroup("build");
            });
            project.getArtifacts().add("archives", this.javadocJar);
        });
        project.getPlugins().withType(AggregateJavadocPlugin.class, aggregateJavadocPlugin -> {
            this.aggregateJavadocJar = project.getTasks().register("aggregateJavadocJar", Jar.class, aggregateJavadocJar -> {
                aggregateJavadocJar.from(new Object[]{aggregateJavadocPlugin.getAggregateJavadoc()});
                aggregateJavadocJar.getArchiveClassifier().set((Object)"javadoc");
                aggregateJavadocJar.setGroup("build");
            });
            project.getPlugins().apply(BasePlugin.class);
            project.getArtifacts().add("archives", this.aggregateJavadocJar);
            project.getPlugins().withType(JavaPlugin.class, javaPlugin -> this.aggregateJavadocJar.configure(aggregateJavadocJar -> {
                aggregateJavadocJar.getArchiveClassifier().convention((Object)"aggregateJavadoc");
                aggregateJavadocJar.getDestinationDirectory().set(new File(((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getDocsDir(), "aggregateJavadoc"));
            }));
        });
    }

    @Generated
    public TaskProvider<Jar> getJavadocJar() {
        return this.javadocJar;
    }

    @Generated
    public TaskProvider<Jar> getAggregateJavadocJar() {
        return this.aggregateJavadocJar;
    }
}

