/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.javadoc;

import java.io.File;
import java.util.Optional;
import lombok.Generated;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;

public class AggregateJavadocPlugin
implements Plugin<Project> {
    private TaskProvider<Javadoc> aggregateJavadoc;

    public void apply(Project project) {
        this.aggregateJavadoc = project.getTasks().register("aggregateJavadoc", Javadoc.class, aggregateJavadoc -> aggregateJavadoc.setGroup("documentation"));
        project.allprojects(p -> p.getPlugins().withType(JavaPlugin.class, jp -> this.aggregateJavadoc.configure(aj -> {
            TaskProvider javadoc = p.getTasks().named("javadoc", Javadoc.class);
            aj.source(new Object[]{javadoc.map(Javadoc::getSource)});
            if (aj.getClasspath() instanceof ConfigurableFileCollection) {
                ((ConfigurableFileCollection)aj.getClasspath()).from(new Object[]{javadoc.map(Javadoc::getClasspath)});
            } else {
                ConfigurableFileCollection classpath = project.files(new Object[0]);
                classpath.from(new Object[]{aj.getClasspath()});
                classpath.from(new Object[]{javadoc.map(Javadoc::getClasspath)});
                aj.setClasspath((FileCollection)classpath);
            }
            StandardJavadocDocletOptions options = (StandardJavadocDocletOptions)((Javadoc)javadoc.get()).getOptions();
            StandardJavadocDocletOptions aggregateOptions = (StandardJavadocDocletOptions)aj.getOptions();
            options.getLinks().forEach(link -> {
                if (!aggregateOptions.getLinks().contains(link)) {
                    aggregateOptions.getLinks().add(link);
                }
            });
            options.getLinksOffline().forEach(link -> {
                if (!aggregateOptions.getLinksOffline().contains(link)) {
                    aggregateOptions.getLinksOffline().add(link);
                }
            });
            options.getJFlags().forEach(jFlag -> {
                if (!aggregateOptions.getJFlags().contains(jFlag)) {
                    aggregateOptions.getJFlags().add(jFlag);
                }
            });
        })));
        project.afterEvaluate(p -> this.aggregateJavadoc.configure(aggregateJavadoc -> {
            if (aggregateJavadoc.getDestinationDir() == null) {
                File docsDir = Optional.ofNullable((JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class)).map(JavaPluginConvention::getDocsDir).orElse(new File(project.getBuildDir(), "docs"));
                aggregateJavadoc.setDestinationDir(new File(docsDir, "aggregateJavadoc"));
            }
        }));
    }

    @Generated
    public TaskProvider<Javadoc> getAggregateJavadoc() {
        return this.aggregateJavadoc;
    }
}

