/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.war;

import groovy.lang.Closure;
import java.util.Set;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.bundling.War;

public class WarOverlay {
    private final String name;
    private final War warTask;
    private CopySpecInternal warCopySpec;
    private Object source;
    private Closure configureClosure;
    private boolean enabled = true;
    private boolean provided = false;
    private boolean deferProvidedConfiguration = true;
    private boolean enableCompilation = true;

    public WarOverlay(String name, War warTask) {
        this.name = name;
        this.warTask = warTask;
        this.warCopySpec = warTask.getRootSpec().addChild();
        this.warCopySpec.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        this.exclude("META-INF/maven/**");
        this.exclude("META-INF/MANIFEST.MF");
    }

    public void from(Object object) {
        this.source = object;
        this.configureClosure = null;
    }

    public void from(Object object, Closure configureClosure) {
        this.source = object;
        this.configureClosure = configureClosure;
    }

    public void provided() {
        this.provided(true);
    }

    public void provided(boolean provided) {
        this.setProvided(provided);
    }

    public void setTargetPath(String targetPath) {
        this.setInto(targetPath);
    }

    public void setSkip(boolean skip) {
        this.setEnabled(!skip);
    }

    public boolean isSkip() {
        return !this.isEnabled();
    }

    public String getConfigurationName() {
        return String.format("%s%sOverlay", this.getName(), StringGroovyMethods.capitalize((CharSequence)this.getWarTask().getName()));
    }

    public void setInto(String destPath) {
        this.into(destPath);
    }

    public void into(Object destPath) {
        this.getWarCopySpec().into(destPath);
    }

    public void setExcludes(Iterable<String> excludes) {
        this.getWarCopySpec().setExcludes(excludes);
    }

    public CopySpec include(String ... includes) {
        return this.getWarCopySpec().include(includes);
    }

    public CopySpec include(Iterable<String> includes) {
        return this.getWarCopySpec().include(includes);
    }

    public CopySpec include(Spec<FileTreeElement> includeSpec) {
        return this.getWarCopySpec().include(includeSpec);
    }

    public CopySpec include(Closure includeSpec) {
        return this.getWarCopySpec().include(includeSpec);
    }

    public void exclude(String ... excludes) {
        this.getWarCopySpec().exclude(excludes);
    }

    public void exclude(Iterable<String> excludes) {
        this.getWarCopySpec().exclude(excludes);
    }

    public void exclude(Spec<FileTreeElement> excludeSpec) {
        this.getWarCopySpec().exclude(excludeSpec);
    }

    public void exclude(Closure excludeSpec) {
        this.getWarCopySpec().exclude(excludeSpec);
    }

    public Set<String> getIncludes() {
        return this.getWarCopySpec().getIncludes();
    }

    public Set<String> getExcludes() {
        return this.getWarCopySpec().getExcludes();
    }

    public CopySpec setIncludes(Iterable<String> includes) {
        return this.getWarCopySpec().setIncludes(includes);
    }

    public String getName() {
        return this.name;
    }

    public War getWarTask() {
        return this.warTask;
    }

    public CopySpecInternal getWarCopySpec() {
        return this.warCopySpec;
    }

    public Object getSource() {
        return this.source;
    }

    public Closure getConfigureClosure() {
        return this.configureClosure;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isProvided() {
        return this.provided;
    }

    public boolean isDeferProvidedConfiguration() {
        return this.deferProvidedConfiguration;
    }

    public boolean isEnableCompilation() {
        return this.enableCompilation;
    }

    public void setWarCopySpec(CopySpecInternal warCopySpec) {
        this.warCopySpec = warCopySpec;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public void setConfigureClosure(Closure configureClosure) {
        this.configureClosure = configureClosure;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setProvided(boolean provided) {
        this.provided = provided;
    }

    public void setDeferProvidedConfiguration(boolean deferProvidedConfiguration) {
        this.deferProvidedConfiguration = deferProvidedConfiguration;
    }

    public void setEnableCompilation(boolean enableCompilation) {
        this.enableCompilation = enableCompilation;
    }
}

