/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.war;

import io.freefair.gradle.plugins.maven.war.WarArchiveClassesConvention;
import java.io.File;
import java.util.Collections;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.War;

public class WarArchiveClassesPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getTasks().withType(War.class, war -> {
            WarArchiveClassesConvention archiveClassesConvention = new WarArchiveClassesConvention();
            war.getConvention().getPlugins().put("archiveClasses", archiveClassesConvention);
            Jar warClassesJar = (Jar)project.getTasks().create(war.getName() + "ClassesJar", Jar.class);
            warClassesJar.getConventionMapping().map("baseName", () -> ((War)war).getBaseName());
            warClassesJar.getConventionMapping().map("appendix", () -> ((War)war).getAppendix());
            warClassesJar.getConventionMapping().map("version", () -> ((War)war).getVersion());
            warClassesJar.getConventionMapping().map("classifier", () -> ((War)war).getClassifier());
            project.afterEvaluate(p -> {
                warClassesJar.setEnabled(archiveClassesConvention.isArchiveClasses());
                if (archiveClassesConvention.isArchiveClasses()) {
                    FileCollection warClasspath = war.getClasspath();
                    warClassesJar.from(new Object[]{warClasspath != null ? warClasspath.filter(File::isDirectory) : Collections.emptyList()});
                    war.setClasspath(warClasspath == null ? null : warClasspath.filter(File::isFile).plus((FileCollection)project.files(new Object[]{warClassesJar})));
                }
            });
        });
    }
}

