/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.plugin.wrappers;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public class MavenProjectWrapper
extends MavenProject {
    private final Project project;
    private final File pomFile;

    public MavenProjectWrapper(Project project, File pomFile) throws IOException, XmlPullParserException {
        this.project = project;
        this.pomFile = pomFile;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = reader.read((Reader)new FileReader(pomFile));
        this.setModel(model);
        this.getBuild().setDirectory(project.getBuildDir().getAbsolutePath());
        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        SourceSet main = (SourceSet)sourceSets.getByName("main");
        this.getBuild().setSourceDirectory(((File)main.getJava().getSrcDirs().iterator().next()).getAbsolutePath());
        this.getBuild().setOutputDirectory(main.getJava().getOutputDir().getAbsolutePath());
        SourceSet test = (SourceSet)sourceSets.getByName("test");
        this.getBuild().setTestSourceDirectory(((File)test.getJava().getSrcDirs().iterator().next()).getAbsolutePath());
        this.getBuild().setTestOutputDirectory(test.getJava().getOutputDir().getAbsolutePath());
        this.setArtifact((Artifact)new ProjectArtifact((MavenProject)this));
    }

    public File getFile() {
        return this.pomFile;
    }

    public File getBasedir() {
        return this.project.getProjectDir();
    }
}

