/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.plugin;

import io.freefair.gradle.plugins.maven.plugin.wrappers.MavenProjectWrapper;
import io.freefair.gradle.plugins.maven.plugin.wrappers.MojoAnnotationScannerWrapper;
import io.freefair.gradle.plugins.maven.plugin.wrappers.PlexusLoggerWrapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.factory.DefaultArtifactFactory;
import org.apache.maven.artifact.resolver.DefaultArtifactResolver;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.annotations.JavaAnnotationsMojoDescriptorExtractor;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.DefaultMojoAnnotationsScanner;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotationsScanner;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.maven.tools.plugin.scanner.DefaultMojoScanner;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.codehaus.plexus.archiver.manager.DefaultArchiverManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class AbstractGeneratorTask
extends DefaultTask {
    @InputFiles
    private final ConfigurableFileCollection sourceDirectories = this.getProject().files(new Object[0]);
    @InputFiles
    private final ConfigurableFileCollection classesDirectories = this.getProject().files(new Object[0]);
    @InputFile
    private final RegularFileProperty pomFile = this.newInputFile();
    @Optional
    @Input
    private final Property<String> goalPrefix = this.getProject().getObjects().property(String.class);

    @TaskAction
    public void generate() throws GeneratorException, IOException, XmlPullParserException, InvalidPluginDescriptorException, ExtractionException {
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        MavenProjectWrapper project = new MavenProjectWrapper(this.getProject(), (File)this.getPomFile().getAsFile().get());
        pluginDescriptor.setName(project.getName());
        pluginDescriptor.setDescription(project.getDescription());
        pluginDescriptor.setGroupId(project.getGroupId());
        pluginDescriptor.setVersion(project.getVersion());
        pluginDescriptor.setArtifactId(project.getArtifactId());
        pluginDescriptor.setGoalPrefix((String)this.goalPrefix.getOrElse((Object)PluginDescriptor.getGoalPrefixFromArtifactId((String)project.getArtifactId())));
        List deps = GeneratorUtils.toComponentDependencies((List)project.getDependencies());
        pluginDescriptor.setDependencies(deps);
        DefaultPluginToolsRequest request = new DefaultPluginToolsRequest((MavenProject)project, pluginDescriptor);
        request.setEncoding("UTF-8");
        MojoScanner mojoScanner = this.getMojoScanner();
        mojoScanner.populatePluginDescriptor((PluginToolsRequest)request);
        this.getGenerator().execute(this.getBaseDir(), (PluginToolsRequest)request);
    }

    protected abstract Generator getGenerator();

    protected abstract File getBaseDir();

    private MojoScanner getMojoScanner() {
        TreeMap<String, JavaAnnotationsMojoDescriptorExtractor> extractors = new TreeMap<String, JavaAnnotationsMojoDescriptorExtractor>();
        JavaAnnotationsMojoDescriptorExtractor mojoDescriptorExtractor = new JavaAnnotationsMojoDescriptorExtractor();
        DefaultMojoAnnotationsScanner delegate = new DefaultMojoAnnotationsScanner();
        delegate.enableLogging((Logger)new PlexusLoggerWrapper(this.getLogger()));
        MojoAnnotationScannerWrapper mojoAnnotationsScanner = new MojoAnnotationScannerWrapper((MojoAnnotationsScanner)delegate);
        mojoAnnotationsScanner.setSourceDirectories((FileCollection)this.sourceDirectories);
        mojoAnnotationsScanner.setClassesDirectories((FileCollection)this.classesDirectories);
        DefaultArtifactResolver artifactResolver = new DefaultArtifactResolver();
        DefaultArtifactFactory artifactFactory = new DefaultArtifactFactory();
        DefaultArchiverManager archiverManager = new DefaultArchiverManager();
        HashMap<String, MojoAnnotationScannerWrapper> values = new HashMap<String, MojoAnnotationScannerWrapper>();
        values.put("mojoAnnotationsScanner", mojoAnnotationsScanner);
        values.put("artifactResolver", (MojoAnnotationScannerWrapper)artifactResolver);
        values.put("artifactFactory", (MojoAnnotationScannerWrapper)artifactFactory);
        values.put("archiverManager", (MojoAnnotationScannerWrapper)archiverManager);
        try {
            Class<JavaAnnotationsMojoDescriptorExtractor> clazz = JavaAnnotationsMojoDescriptorExtractor.class;
            for (Map.Entry entry : values.entrySet()) {
                Field declaredField = clazz.getDeclaredField((String)entry.getKey());
                declaredField.setAccessible(true);
                declaredField.set(mojoDescriptorExtractor, entry.getValue());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        extractors.put("java-annotations", mojoDescriptorExtractor);
        DefaultMojoScanner defaultMojoScanner = new DefaultMojoScanner(extractors);
        defaultMojoScanner.enableLogging((Logger)new PlexusLoggerWrapper(this.getLogger()));
        return defaultMojoScanner;
    }

    public ConfigurableFileCollection getSourceDirectories() {
        return this.sourceDirectories;
    }

    public ConfigurableFileCollection getClassesDirectories() {
        return this.classesDirectories;
    }

    public RegularFileProperty getPomFile() {
        return this.pomFile;
    }

    public Property<String> getGoalPrefix() {
        return this.goalPrefix;
    }
}

