/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.javadoc;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;

public class JavadocLinksPlugin
implements Plugin<Project> {
    private Project project;
    private OkHttpClient okHttpClient;
    private static final Map<String, Boolean> javadocIoLinkCache = new HashMap<String, Boolean>();

    public void apply(Project project) {
        this.project = project;
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(message -> project.getLogger().info(message));
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
        this.okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)loggingInterceptor).build();
        project.getTasks().withType(Javadoc.class, javadoc -> {
            this.addLink((Javadoc)javadoc, this.getJavaSeLink(JavaVersion.current()));
            javadoc.doFirst(task -> {
                this.findConfigurations(javadoc.getClasspath()).flatMap(files -> files.getResolvedConfiguration().getResolvedArtifacts().stream()).map(resolvedArtifact -> resolvedArtifact.getId().getComponentIdentifier()).filter(ModuleComponentIdentifier.class::isInstance).map(ModuleComponentIdentifier.class::cast).map(moduleComponentIdentifier -> {
                    String version;
                    String artifact;
                    String group = moduleComponentIdentifier.getGroup();
                    String wellKnownLink = this.findWellKnownLink(group, artifact = moduleComponentIdentifier.getModule(), version = moduleComponentIdentifier.getVersion());
                    if (wellKnownLink != null) {
                        javadoc.getLogger().info("Using well known link '{}' for '{}:{}:{}'", new Object[]{wellKnownLink, group, artifact, version});
                        return wellKnownLink;
                    }
                    String javadocIoLink = String.format("https://static.javadoc.io/%s/%s/%s/", group, artifact, version);
                    if (this.checkLink(javadocIoLink)) {
                        javadoc.getLogger().info("Using javadoc.io link for '{}:{}:{}'", new Object[]{group, artifact, version});
                        return javadocIoLink;
                    }
                    return null;
                }).filter(Objects::nonNull).forEach(link -> this.addLink((Javadoc)javadoc, (String)link));
                boolean usedJavadocIo = this.getLinks((Javadoc)javadoc).stream().anyMatch(link -> link.startsWith("https://static.javadoc.io"));
                if (usedJavadocIo && javadoc.getOptions().getJFlags().stream().noneMatch(flag -> flag.contains("http.agent"))) {
                    javadoc.getOptions().jFlags(new String[]{"-Dhttp.agent=" + System.currentTimeMillis()});
                }
            });
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkLink(String link) {
        if (javadocIoLinkCache.containsKey(link)) {
            return javadocIoLinkCache.get(link);
        }
        Request request = new Request.Builder().url(link + "package-list").head().header("User-Agent", String.valueOf(System.nanoTime())).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            boolean successful = response.isSuccessful();
            javadocIoLinkCache.put(link, successful);
            boolean bl = successful;
            return bl;
        }
    }

    private void addLink(Javadoc javadoc, String link) {
        MinimalJavadocOptions options = javadoc.getOptions();
        if (options instanceof StandardJavadocDocletOptions) {
            StandardJavadocDocletOptions docletOptions = (StandardJavadocDocletOptions)options;
            Logger logger = javadoc.getLogger();
            List links = docletOptions.getLinks();
            if (links == null || !links.contains(link)) {
                logger.debug("Adding '{}' to {}", (Object)link, (Object)javadoc);
                docletOptions.links(new String[]{link});
            } else {
                logger.info("Not adding '{}' to {} because it's already present", (Object)link, (Object)javadoc);
            }
        }
    }

    private List<String> getLinks(Javadoc javadoc) {
        MinimalJavadocOptions options = javadoc.getOptions();
        if (options instanceof StandardJavadocDocletOptions) {
            return ((StandardJavadocDocletOptions)options).getLinks();
        }
        return Collections.emptyList();
    }

    private String findWellKnownLink(String group, String artifact, String version) {
        if (group.equals("javax") && artifact.equals("javaee-api") && version.matches("[567]\\..*")) {
            return "https://docs.oracle.com/javaee/" + version.substring(0, 1) + "/api/";
        }
        if (group.equals("javax") && artifact.equals("javaee-api") && version.startsWith("8")) {
            return "https://javaee.github.io/javaee-spec/javadocs/";
        }
        if (group.equals("org.springframework") && artifact.startsWith("spring-")) {
            return "https://docs.spring.io/spring/docs/" + version + "/javadoc-api/";
        }
        if (group.equals("org.springframework.boot") && artifact.startsWith("spring-boot")) {
            return "https://docs.spring.io/spring-boot/docs/" + version + "/api/";
        }
        if (group.equals("org.springframework.security") && artifact.startsWith("spring-security")) {
            return "https://docs.spring.io/spring-security/site/docs/" + version + "/api/";
        }
        if (group.equals("org.springframework.data") && artifact.equals("spring-data-jpa")) {
            return "https://docs.spring.io/spring-data/jpa/docs/" + version + "/api/";
        }
        if (group.equals("org.springframework.webflow") && artifact.equals("spring-webflow")) {
            return "https://docs.spring.io/spring-webflow/docs/" + version + "/api/";
        }
        if (group.equals("com.squareup.okio") && version.startsWith("1.")) {
            return "https://square.github.io/okio/1.x/" + artifact + "/";
        }
        if (group.equals("com.squareup.okhttp3")) {
            return "https://square.github.io/okhttp/3.x/" + artifact + "/";
        }
        if (group.equals("com.squareup.retrofit")) {
            return "https://square.github.io/retrofit/1.x/retrofit/";
        }
        if (group.equals("com.squareup.retrofit2")) {
            return "https://square.github.io/retrofit/2.x/" + artifact + "/";
        }
        if (group.equals("org.hibernate") && artifact.equals("hibernate-core")) {
            return "https://docs.jboss.org/hibernate/orm/" + version.substring(0, 3) + "/javadocs/";
        }
        if ((group.equals("org.hibernate") || group.equals("org.hibernate.validator")) && artifact.equals("hibernate-validator")) {
            return "https://docs.jboss.org/hibernate/validator/" + version.substring(0, 3) + "/api/";
        }
        if (group.equals("org.primefaces") && artifact.equals("primefaces")) {
            return "https://www.primefaces.org/docs/api/" + version + "/";
        }
        if (group.equals("org.eclipse.jetty")) {
            return "https://www.eclipse.org/jetty/javadoc/" + version + "/";
        }
        if (group.equals("org.ow2.asm")) {
            return "https://asm.ow2.io/javadoc/";
        }
        if (group.equals("org.joinfaces")) {
            return "https://docs.joinfaces.org/" + version + "/api/";
        }
        return null;
    }

    private Stream<Configuration> findConfigurations(FileCollection classpath) {
        if (classpath instanceof Configuration) {
            return Stream.of((Configuration)classpath);
        }
        if (classpath instanceof UnionFileCollection) {
            return ((UnionFileCollection)classpath).getSources().stream().flatMap(this::findConfigurations);
        }
        return Stream.empty();
    }

    private String getJavaSeLink(JavaVersion javaVersion) {
        if (javaVersion.isJava11Compatible()) {
            return "https://docs.oracle.com/javase/10/docs/api/";
        }
        return "https://docs.oracle.com/javase/" + javaVersion.getMajorVersion() + "/docs/api/";
    }

    public Project getProject() {
        return this.project;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }
}

