/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.javadoc;

import io.freefair.gradle.plugins.maven.javadoc.AggregateJavadocPlugin;
import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.javadoc.Javadoc;

public class JavadocJarPlugin
implements Plugin<Project> {
    private Jar javadocJar;
    private Jar aggregateJavadocJar;

    public void apply(Project project) {
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            Javadoc javadoc = (Javadoc)project.getTasks().getByName("javadoc");
            this.javadocJar = (Jar)project.getTasks().create("javadocJar", Jar.class);
            this.javadocJar.from(new Object[]{javadoc});
            this.javadocJar.setClassifier("javadoc");
            this.javadocJar.setDescription("Assembles a jar archive containing the javadocs.");
            this.javadocJar.setGroup("build");
            project.getArtifacts().add("archives", (Object)this.javadocJar);
        });
        project.getPlugins().withType(AggregateJavadocPlugin.class, aggregateJavadocPlugin -> {
            Javadoc aggregateJavadoc = aggregateJavadocPlugin.getAggregateJavadoc();
            this.aggregateJavadocJar = (Jar)project.getTasks().create("aggregateJavadocJar", Jar.class);
            this.aggregateJavadocJar.from(new Object[]{aggregateJavadoc});
            this.aggregateJavadocJar.setClassifier("javadoc");
            this.aggregateJavadocJar.setGroup("build");
            project.getPlugins().apply(BasePlugin.class);
            project.getArtifacts().add("archives", (Object)this.aggregateJavadocJar);
            project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
                this.aggregateJavadocJar.setClassifier("aggregateJavadoc");
                this.aggregateJavadocJar.setDestinationDir(new File(((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getDocsDir(), "aggregateJavadoc"));
            });
        });
    }

    public Jar getJavadocJar() {
        return this.javadocJar;
    }

    public Jar getAggregateJavadocJar() {
        return this.aggregateJavadocJar;
    }
}

