/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.javadoc;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.UnionFileTree;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;

public class AggregateJavadocPlugin
implements Plugin<Project> {
    private Javadoc aggregateJavadoc;

    public void apply(Project project) {
        this.aggregateJavadoc = (Javadoc)project.getTasks().create("aggregateJavadoc", Javadoc.class);
        this.aggregateJavadoc.setGroup("documentation");
        project.afterEvaluate(p -> {
            if (this.aggregateJavadoc.getDestinationDir() == null) {
                File docsDir = Optional.ofNullable(project.getConvention().findPlugin(JavaPluginConvention.class)).map(JavaPluginConvention::getDocsDir).orElse(new File(project.getBuildDir(), "docs"));
                this.aggregateJavadoc.setDestinationDir(new File(docsDir, "aggregateJavadoc"));
            }
            List<Javadoc> javadocTasks = Stream.concat(Stream.of(project), project.getSubprojects().stream().peek(sub -> project.evaluationDependsOn(sub.getPath()))).filter(sub -> sub.getPlugins().hasPlugin(JavaPlugin.class)).map(sub -> (Javadoc)sub.getTasks().getByName("javadoc")).collect(Collectors.toList());
            this.aggregateJavadoc.setClasspath((FileCollection)new UnionFileCollection((Iterable)javadocTasks.stream().map(Javadoc::getClasspath).collect(Collectors.toList())));
            this.aggregateJavadoc.setSource((FileTree)new UnionFileTree("aggregated sources", (Collection)javadocTasks.stream().map(Javadoc::getSource).map(FileTreeInternal.class::cast).collect(Collectors.toList())));
            StandardJavadocDocletOptions aggregateJavadocOptions = (StandardJavadocDocletOptions)this.aggregateJavadoc.getOptions();
            javadocTasks.forEach(jd -> {
                StandardJavadocDocletOptions javadocOptions = (StandardJavadocDocletOptions)jd.getOptions();
                javadocOptions.getLinks().forEach(link -> {
                    if (!aggregateJavadocOptions.getLinks().contains(link)) {
                        aggregateJavadocOptions.links(new String[]{link});
                    }
                });
                javadocOptions.getLinksOffline().forEach(offlineLink -> {
                    if (!aggregateJavadocOptions.getLinksOffline().contains(offlineLink)) {
                        aggregateJavadocOptions.getLinksOffline().add(offlineLink);
                    }
                });
                javadocOptions.getJFlags().forEach(jFlag -> {
                    if (!aggregateJavadocOptions.getJFlags().contains(jFlag)) {
                        aggregateJavadocOptions.jFlags(new String[]{jFlag});
                    }
                });
            });
        });
    }

    public Javadoc getAggregateJavadoc() {
        return this.aggregateJavadoc;
    }
}

