/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.bundling.Jar;

public class SourcesJarPlugin
implements Plugin<Project> {
    private Jar sourcesJar;

    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", appliedPlugin -> {
            this.sourcesJar = (Jar)project.getTasks().create("sourcesJar", Jar.class);
            this.sourcesJar.setDescription("Assembles a jar archive containing the sources.");
            this.sourcesJar.setClassifier("sources");
            this.sourcesJar.setGroup("build");
            project.getArtifacts().add("archives", (Object)this.sourcesJar);
            this.sourcesJar.dependsOn(new Object[]{project.getTasks().getByName("classes")});
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            DefaultSourceSet mainSourceSet = (DefaultSourceSet)javaPluginConvention.getSourceSets().getByName("main");
            this.sourcesJar.from(new Object[]{mainSourceSet.getAllSource()});
        });
    }

    public Jar getSourcesJar() {
        return this.sourcesJar;
    }
}

