/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven;

import io.freefair.gradle.plugins.maven.SourcesJarPlugin;
import io.freefair.gradle.plugins.maven.javadoc.JavadocJarPlugin;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;

public abstract class MavenPublishBasePlugin
implements Plugin<Project> {
    private Project project;
    private MavenPublication publication;

    public void apply(Project project) {
        this.project = project;
        project.getPlugins().apply(this.getPluginClass());
        project.getPlugins().apply(MavenPublishPlugin.class);
        this.publication = (MavenPublication)((PublishingExtension)project.getExtensions().getByType(PublishingExtension.class)).getPublications().create(this.getPublicationName(), MavenPublication.class);
        project.afterEvaluate(p -> {
            this.publication.from(this.getSoftwareComponent());
            project.getPlugins().withType(SourcesJarPlugin.class, sourcesJarPlugin -> this.publication.artifact((Object)sourcesJarPlugin.getSourcesJar()));
            project.getPlugins().withType(JavadocJarPlugin.class, javadocJarPlugin -> {
                if (javadocJarPlugin.getJavadocJar() != null) {
                    this.publication.artifact((Object)javadocJarPlugin.getJavadocJar());
                }
                if (javadocJarPlugin.getAggregateJavadocJar() != null) {
                    this.publication.artifact((Object)javadocJarPlugin.getAggregateJavadocJar());
                }
            });
            project.getPlugins().withType(SigningPlugin.class, signingPlugin -> ((SigningExtension)project.getExtensions().getByType(SigningExtension.class)).sign(new Publication[]{this.publication}));
        });
    }

    protected abstract Class<? extends Plugin> getPluginClass();

    public String getPublicationName() {
        return "maven" + StringGroovyMethods.capitalize((CharSequence)this.getComponentName());
    }

    public SoftwareComponent getSoftwareComponent() {
        return (SoftwareComponent)this.getProject().getComponents().getByName(this.getComponentName());
    }

    abstract String getComponentName();

    public Project getProject() {
        return this.project;
    }

    public MavenPublication getPublication() {
        return this.publication;
    }
}

