/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.sass;

import de.larsgrefer.sass.embedded.SassCompilationFailedException;
import de.larsgrefer.sass.embedded.SassCompiler;
import de.larsgrefer.sass.embedded.SassCompilerFactory;
import de.larsgrefer.sass.embedded.functions.HostFunction;
import de.larsgrefer.sass.embedded.importer.CustomImporter;
import de.larsgrefer.sass.embedded.importer.FileImporter;
import de.larsgrefer.sass.embedded.importer.WebjarsImporter;
import de.larsgrefer.sass.embedded.logging.LoggingHandler;
import de.larsgrefer.sass.embedded.logging.Slf4jLoggingHandler;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.List;
import lombok.Generated;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.webjars.WebJarAssetLocator;
import sass.embedded_protocol.EmbeddedSass;

@CacheableTask
@Incubating
public class SassCompile
extends SourceTask {
    @Internal
    private final DirectoryProperty destinationDir = this.getProject().getObjects().directoryProperty();
    @Input
    @Optional
    private ListProperty<HostFunction> hostFunctions = this.getProject().getObjects().listProperty(HostFunction.class);
    @Input
    @Optional
    private ListProperty<FileImporter> fileImporters = this.getProject().getObjects().listProperty(FileImporter.class);
    @Input
    @Optional
    private ListProperty<CustomImporter> customImporters = this.getProject().getObjects().listProperty(CustomImporter.class);
    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    private final ConfigurableFileCollection webjars = this.getProject().files(new Object[0]);
    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    private final ConfigurableFileCollection includePaths = this.getProject().files(new Object[0]);
    @Input
    private final Property<Boolean> omitSourceMapUrl = this.getProject().getObjects().property(Boolean.class);
    @Input
    private final Property<EmbeddedSass.OutputStyle> outputStyle = this.getProject().getObjects().property(EmbeddedSass.OutputStyle.class);
    @Input
    private final Property<Boolean> sourceMapContents = this.getProject().getObjects().property(Boolean.class);
    @Input
    private final Property<Boolean> sourceMapEmbed = this.getProject().getObjects().property(Boolean.class);
    @Input
    private final Property<Boolean> sourceMapEnabled = this.getProject().getObjects().property(Boolean.class);
    @Input
    @Optional
    private final Property<URI> sourceMapRoot = this.getProject().getObjects().property(URI.class);

    public SassCompile() {
        this.include(new String[]{"**/*.scss"});
        this.include(new String[]{"**/*.sass"});
        ExtraPropertiesExtension extraProperties = new DslObject((Object)this).getExtensions().getExtraProperties();
        for (EmbeddedSass.OutputStyle value : EmbeddedSass.OutputStyle.values()) {
            extraProperties.set(value.name(), (Object)value);
        }
    }

    @OutputFiles
    protected FileTree getOutputFiles() {
        ConfigurableFileTree files = this.getProject().fileTree((Object)this.destinationDir);
        files.include(new String[]{"**/*.css"});
        files.include(new String[]{"**/*.css.map"});
        return files;
    }

    @TaskAction
    public void compileSass() throws IOException {
        try (final SassCompiler compiler = SassCompilerFactory.bundled();){
            compiler.setOutputStyle((EmbeddedSass.OutputStyle)this.getOutputStyle().getOrNull());
            compiler.setGenerateSourceMaps(((Boolean)this.sourceMapEnabled.getOrElse((Object)true)).booleanValue());
            compiler.setLoggingHandler((LoggingHandler)new Slf4jLoggingHandler((Logger)this.getLogger()));
            compiler.getLoadPaths().addAll(this.getIncludePaths().getFiles());
            ((List)this.fileImporters.get()).forEach(arg_0 -> ((SassCompiler)compiler).registerImporter(arg_0));
            ((List)this.customImporters.get()).forEach(arg_0 -> ((SassCompiler)compiler).registerImporter(arg_0));
            ((List)this.hostFunctions.get()).forEach(arg_0 -> ((SassCompiler)compiler).registerFunction(arg_0));
            if (!this.webjars.isEmpty()) {
                LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
                for (File webjar : this.webjars) {
                    urls.add(webjar.toURI().toURL());
                }
                URLClassLoader webjarsLoader = new URLClassLoader(urls.toArray(new URL[0]));
                compiler.registerImporter(new WebjarsImporter((ClassLoader)webjarsLoader, new WebJarAssetLocator((ClassLoader)webjarsLoader)).autoCanonicalize());
            }
            EmbeddedSass.OutboundMessage.VersionResponse version = compiler.getVersion();
            this.getLogger().info("{}", (Object)version);
            this.getSource().visit(new FileVisitor(){

                public void visitDir(FileVisitDetails fileVisitDetails) {
                }

                public void visitFile(FileVisitDetails fileVisitDetails) {
                    block9: {
                        String name = fileVisitDetails.getName();
                        if (name.startsWith("_")) {
                            return;
                        }
                        if (name.endsWith(".scss") || name.endsWith(".sass")) {
                            File in = fileVisitDetails.getFile();
                            String pathString = fileVisitDetails.getRelativePath().getPathString();
                            pathString = pathString.substring(0, pathString.length() - 5) + ".css";
                            File realOut = new File(((Directory)SassCompile.this.getDestinationDir().get()).getAsFile(), pathString);
                            File realMap = new File(((Directory)SassCompile.this.getDestinationDir().get()).getAsFile(), pathString + ".map");
                            try {
                                String css;
                                EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess output = compiler.compileFile(in, (EmbeddedSass.OutputStyle)SassCompile.this.getOutputStyle().getOrNull());
                                if (realOut.getParentFile().exists() || realOut.getParentFile().mkdirs()) {
                                    css = output.getCss();
                                    if (((Boolean)SassCompile.this.sourceMapEnabled.get()).booleanValue()) {
                                        String mapUrl = (Boolean)SassCompile.this.sourceMapEmbed.get() != false ? "data:application/json;base64," + Base64.getEncoder().encodeToString(output.getSourceMapBytes().toByteArray()) : realMap.getName();
                                        css = css + "\n/*# sourceMappingURL=" + mapUrl + " */";
                                    }
                                } else {
                                    SassCompile.this.getLogger().error("Cannot write into {}", (Object)realOut.getParentFile());
                                    throw new GradleException("Cannot write into " + realMap.getParentFile());
                                }
                                Files.write(realOut.toPath(), css.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                                if (!((Boolean)SassCompile.this.sourceMapEnabled.get()).booleanValue() || ((Boolean)SassCompile.this.sourceMapEmbed.get()).booleanValue()) break block9;
                                if (realMap.getParentFile().exists() || realMap.getParentFile().mkdirs()) {
                                    Files.write(realMap.toPath(), output.getSourceMap().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                                    break block9;
                                }
                                SassCompile.this.getLogger().error("Cannot write into {}", (Object)realMap.getParentFile());
                                throw new GradleException("Cannot write into " + realMap.getParentFile());
                            }
                            catch (SassCompilationFailedException e) {
                                EmbeddedSass.OutboundMessage.CompileResponse.CompileFailure sassError = e.getCompileFailure();
                                SassCompile.this.getLogger().error(sassError.getMessage());
                                throw new RuntimeException(e);
                            }
                            catch (IOException e) {
                                SassCompile.this.getLogger().error(e.getLocalizedMessage());
                                throw new UncheckedIOException((Throwable)e);
                            }
                        }
                    }
                }
            });
        }
    }

    public void setOutputStyle(String outputStyle) {
        this.outputStyle.set((Object)EmbeddedSass.OutputStyle.valueOf((String)outputStyle.trim().toUpperCase()));
    }

    @Generated
    public DirectoryProperty getDestinationDir() {
        return this.destinationDir;
    }

    @Generated
    public ListProperty<HostFunction> getHostFunctions() {
        return this.hostFunctions;
    }

    @Generated
    public ListProperty<FileImporter> getFileImporters() {
        return this.fileImporters;
    }

    @Generated
    public ListProperty<CustomImporter> getCustomImporters() {
        return this.customImporters;
    }

    @Generated
    public ConfigurableFileCollection getWebjars() {
        return this.webjars;
    }

    @Generated
    public ConfigurableFileCollection getIncludePaths() {
        return this.includePaths;
    }

    @Generated
    public Property<Boolean> getOmitSourceMapUrl() {
        return this.omitSourceMapUrl;
    }

    @Generated
    public Property<EmbeddedSass.OutputStyle> getOutputStyle() {
        return this.outputStyle;
    }

    @Generated
    public Property<Boolean> getSourceMapContents() {
        return this.sourceMapContents;
    }

    @Generated
    public Property<Boolean> getSourceMapEmbed() {
        return this.sourceMapEmbed;
    }

    @Generated
    public Property<Boolean> getSourceMapEnabled() {
        return this.sourceMapEnabled;
    }

    @Generated
    public Property<URI> getSourceMapRoot() {
        return this.sourceMapRoot;
    }

    @Generated
    public void setHostFunctions(ListProperty<HostFunction> hostFunctions) {
        this.hostFunctions = hostFunctions;
    }

    @Generated
    public void setFileImporters(ListProperty<FileImporter> fileImporters) {
        this.fileImporters = fileImporters;
    }

    @Generated
    public void setCustomImporters(ListProperty<CustomImporter> customImporters) {
        this.customImporters = customImporters;
    }
}

