/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj;

import io.freefair.gradle.plugins.aspectj.AspectJBasePlugin;
import io.freefair.gradle.plugins.aspectj.AspectJPostCompileWeavingPlugin;
import io.freefair.gradle.plugins.aspectj.AspectjCompile;
import io.freefair.gradle.plugins.aspectj.AspectjSourceDirectorySet;
import io.freefair.gradle.plugins.aspectj.AspectjSourceSet;
import io.freefair.gradle.plugins.aspectj.WeavingSourceSet;
import io.freefair.gradle.plugins.aspectj.internal.DefaultAspectjSourceSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;

public class AspectJPlugin
implements Plugin<Project> {
    private Project project;
    private Provider<JavaLauncher> defaultLauncher;

    public void apply(Project project) {
        if (project.getPlugins().hasPlugin(AspectJPostCompileWeavingPlugin.class)) {
            throw new IllegalStateException("Another aspectj plugin (which is excludes this one) has already been applied to the project.");
        }
        project.getPlugins().withId("com.android.application", ignored -> {
            throw new IllegalStateException("The 'io.freefair.aspectj' plugin is not compatible with android projects");
        });
        project.getPlugins().withId("com.android.library", ignored -> {
            throw new IllegalStateException("The 'io.freefair.aspectj' plugin is not compatible with android projects");
        });
        this.project = project;
        project.getPlugins().apply(AspectJBasePlugin.class);
        project.getPlugins().apply(JavaBasePlugin.class);
        JavaPluginExtension plugin = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        JavaToolchainService service = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        this.defaultLauncher = service.launcherFor(plugin.getToolchain());
        plugin.getSourceSets().all(this::configureSourceSet);
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            SourceSet main = (SourceSet)plugin.getSourceSets().getByName("main");
            SourceSet test = (SourceSet)plugin.getSourceSets().getByName("test");
            Configuration aspectpath = project.getConfigurations().getByName(WeavingSourceSet.getAspectConfigurationName(main));
            Configuration testAspectpath = project.getConfigurations().getByName(WeavingSourceSet.getAspectConfigurationName(test));
            testAspectpath.extendsFrom(new Configuration[]{aspectpath});
            WeavingSourceSet.getAspectPath(test).setFrom(new Object[]{main.getOutput(), testAspectpath});
        });
    }

    private void configureSourceSet(SourceSet sourceSet) {
        DefaultAspectjSourceSet aspectjSourceSet = new DefaultAspectjSourceSet(this.project.getObjects(), sourceSet);
        new DslObject((Object)sourceSet).getConvention().getPlugins().put("aspectj", aspectjSourceSet);
        AspectjSourceDirectorySet aspectjSource = AspectjSourceSet.getAspectj(sourceSet);
        aspectjSource.srcDir("src/" + sourceSet.getName() + "/aspectj");
        AspectjSourceDirectorySet aspectjSourceFileCollection = aspectjSource;
        sourceSet.getResources().getFilter().exclude(arg_0 -> AspectJPlugin.lambda$configureSourceSet$3((FileCollection)aspectjSourceFileCollection, arg_0));
        sourceSet.getAllJava().source((SourceDirectorySet)aspectjSource);
        sourceSet.getAllSource().source((SourceDirectorySet)aspectjSource);
        Configuration aspect = (Configuration)this.project.getConfigurations().create(WeavingSourceSet.getAspectConfigurationName(sourceSet));
        WeavingSourceSet.getAspectPath(sourceSet).from(new Object[]{aspect});
        Configuration inpath = (Configuration)this.project.getConfigurations().create(WeavingSourceSet.getInpathConfigurationName(sourceSet));
        WeavingSourceSet.getInPath(sourceSet).from(new Object[]{inpath});
        this.project.getConfigurations().getByName(sourceSet.getImplementationConfigurationName()).extendsFrom(new Configuration[]{aspect});
        this.project.getConfigurations().getByName(sourceSet.getCompileOnlyConfigurationName()).extendsFrom(new Configuration[]{inpath});
        TaskProvider compileTask = this.project.getTasks().register(sourceSet.getCompileTaskName("aspectj"), AspectjCompile.class, compile -> {
            JvmPluginsHelper.configureForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)aspectjSource, (AbstractCompile)compile, (CompileOptions)compile.getOptions(), (Project)this.project);
            compile.dependsOn(new Object[]{sourceSet.getCompileJavaTaskName()});
            compile.getLauncher().convention(this.defaultLauncher);
            compile.setDescription("Compiles the " + sourceSet.getName() + " AspectJ source.");
            compile.setSource((FileTree)aspectjSource);
            compile.getAjcOptions().getAspectpath().from(new Object[]{WeavingSourceSet.getAspectPath(sourceSet)});
            compile.getAjcOptions().getInpath().from(new Object[]{WeavingSourceSet.getInPath(sourceSet)});
        });
        JvmPluginsHelper.configureOutputDirectoryForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)aspectjSource, (Project)this.project, (TaskProvider)compileTask, (Provider)compileTask.map(AspectjCompile::getOptions));
        this.project.getTasks().named(sourceSet.getClassesTaskName(), task -> task.dependsOn(new Object[]{compileTask}));
    }

    private static /* synthetic */ boolean lambda$configureSourceSet$3(FileCollection aspectjSourceFileCollection, FileTreeElement element) {
        return aspectjSourceFileCollection.contains(element.getFile());
    }
}

