/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj;

import io.freefair.gradle.plugins.aspectj.AspectJCompileOptions;
import io.freefair.gradle.plugins.aspectj.internal.AspectJCompileSpec;
import io.freefair.gradle.plugins.aspectj.internal.AspectJCompiler;
import java.io.File;
import java.util.ArrayList;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.process.internal.JavaExecHandleFactory;

@CacheableTask
public class AspectjCompile
extends AbstractCompile {
    private final FileSystemOperations fileSystemOperations;
    private final ProjectLayout projectLayout;
    @Classpath
    private final ConfigurableFileCollection aspectjClasspath = this.getProject().getObjects().fileCollection();
    @Nested
    private final CompileOptions options = (CompileOptions)this.getProject().getObjects().newInstance(CompileOptions.class, new Object[0]);
    @Nested
    private final AspectJCompileOptions ajcOptions = (AspectJCompileOptions)((Object)this.getProject().getObjects().newInstance(AspectJCompileOptions.class, new Object[0]));

    @Inject
    public AspectjCompile(FileSystemOperations fileSystemOperations, ProjectLayout projectLayout) {
        this.fileSystemOperations = fileSystemOperations;
        this.projectLayout = projectLayout;
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @CompileClasspath
    public FileCollection getClasspath() {
        return super.getClasspath();
    }

    @TaskAction
    protected void compile() {
        this.fileSystemOperations.delete(spec -> spec.delete(new Object[]{this.getDestinationDirectory()}).setFollowSymlinks(false));
        AspectJCompileSpec spec2 = this.createSpec();
        WorkResult result = this.getCompiler().execute(spec2);
        this.setDidWork(result.getDidWork());
    }

    private AspectJCompiler getCompiler() {
        return new AspectJCompiler((JavaExecHandleFactory)this.getServices().get(JavaExecHandleFactory.class));
    }

    private AspectJCompileSpec createSpec() {
        AspectJCompileSpec spec = new AspectJCompileSpec();
        spec.setSourceFiles((Iterable)this.getSource());
        spec.setDestinationDir((File)this.getDestinationDirectory().getAsFile().get());
        spec.setWorkingDir(this.projectLayout.getProjectDirectory().getAsFile());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath(new ArrayList(this.getClasspath().getFiles()));
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setAspectJClasspath((FileCollection)this.getAspectjClasspath());
        spec.setAspectJCompileOptions(this.getAjcOptions());
        return spec;
    }

    public void options(Action<CompileOptions> action) {
        action.execute((Object)this.getOptions());
    }

    public void ajcOptions(Action<AspectJCompileOptions> action) {
        action.execute((Object)this.getAjcOptions());
    }

    @Generated
    public ConfigurableFileCollection getAspectjClasspath() {
        return this.aspectjClasspath;
    }

    @Generated
    public CompileOptions getOptions() {
        return this.options;
    }

    @Generated
    public AspectJCompileOptions getAjcOptions() {
        return this.ajcOptions;
    }
}

