/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj.internal;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import org.gradle.api.Buildable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.FailingFileCollection;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectJRuntime {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AspectJRuntime.class);
    private final ProjectInternal project;
    private static final Pattern aspectjVersionPattern = Pattern.compile("aspectj\\w+-(\\d.*).jar");

    public AspectJRuntime(Project project) {
        this.project = (ProjectInternal)project;
    }

    public FileCollection inferAspectjClasspath(final FileCollection classpath) {
        return new LazilyInitializedFileCollection(){

            public String getDisplayName() {
                return "AspectJ runtime classpath";
            }

            public FileCollection createDelegate() {
                try {
                    return this.inferAspectjClasspath();
                }
                catch (RuntimeException e) {
                    return new FailingFileCollection(this.getDisplayName(), e);
                }
            }

            private FileCollection inferAspectjClasspath() {
                File aspectjtoolsJarFile = AspectJRuntime.findAspectjtoolsJarFile(classpath);
                if (aspectjtoolsJarFile != null) {
                    log.warn("Found tools jar: {}", (Object)aspectjtoolsJarFile);
                    return AspectJRuntime.this.project.getLayout().files(new Object[]{aspectjtoolsJarFile});
                }
                String versionNumber = AspectJRuntime.findAspectjVersion(classpath);
                if (versionNumber == null) {
                    throw new GradleException(String.format("Cannot infer AspectJ class path because no AspectJ Jar was found on class path: %s", classpath));
                }
                String notation = "org.aspectj:aspectjtools:" + versionNumber;
                return this.detachedRuntimeClasspath(AspectJRuntime.this.project.getDependencies().create((Object)notation));
            }

            private Configuration detachedRuntimeClasspath(Dependency ... dependencies) {
                Configuration classpath2 = AspectJRuntime.this.project.getConfigurations().detachedConfiguration(dependencies);
                AspectJRuntime.this.jvmEcosystemUtilities().configureAsRuntimeClasspath((HasConfigurableAttributes)classpath2);
                return classpath2;
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                if (classpath instanceof Buildable) {
                    context.add((Object)classpath);
                }
            }
        };
    }

    @Nullable
    private static File findAspectjtoolsJarFile(FileCollection classpath) {
        for (File file : classpath) {
            if (!file.getName().startsWith("aspectjtools") || !file.getName().endsWith(".jar")) continue;
            return file;
        }
        return null;
    }

    private static String findAspectjVersion(FileCollection classpath) {
        for (File file : classpath) {
            Matcher matcher = aspectjVersionPattern.matcher(file.getName());
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        for (File file : classpath) {
            String fileName = file.getName();
            if (!fileName.startsWith("aspectj") || !fileName.endsWith(".jar")) continue;
            try {
                Object version;
                JarFile jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null || (version = manifest.getMainAttributes().get("Implementation-Version")) == null) continue;
                return version.toString();
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private JvmEcosystemUtilities jvmEcosystemUtilities() {
        return (JvmEcosystemUtilities)this.project.getServices().get(JvmEcosystemUtilities.class);
    }
}

