/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj;

import io.freefair.gradle.plugins.aspectj.AjcAction;
import io.freefair.gradle.plugins.aspectj.AspectJBasePlugin;
import io.freefair.gradle.plugins.aspectj.AspectJPlugin;
import io.freefair.gradle.plugins.aspectj.WeavingSourceSet;
import io.freefair.gradle.plugins.aspectj.internal.DefaultWeavingSourceSet;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.scala.ScalaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.AbstractCompile;

@NonNullApi
public class AspectJPostCompileWeavingPlugin
implements Plugin<Project> {
    private Project project;
    private AspectJBasePlugin aspectjBasePlugin;
    private SourceSetContainer sourceSets;

    public void apply(Project project) {
        if (project.getPlugins().hasPlugin(AspectJPlugin.class)) {
            throw new IllegalStateException("Another aspectj plugin (which is excludes this one) has already been applied to the project.");
        }
        this.project = project;
        this.aspectjBasePlugin = (AspectJBasePlugin)project.getPlugins().apply(AspectJBasePlugin.class);
        project.getPlugins().apply(JavaBasePlugin.class);
        this.sourceSets = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
        this.sourceSets.all(this::configureSourceSetDefaults);
        project.getPlugins().withType(JavaPlugin.class, plugin -> this.configurePlugin("java"));
        project.getPlugins().withType(GroovyPlugin.class, plugin -> this.configurePlugin("groovy"));
        project.getPlugins().withType(ScalaPlugin.class, plugin -> this.configurePlugin("scala"));
        project.getPlugins().withId("org.jetbrains.kotlin.jvm", plugin -> this.configurePlugin("kotlin"));
    }

    private void configureSourceSetDefaults(SourceSet sourceSet) {
        DefaultWeavingSourceSet weavingSourceSet = new DefaultWeavingSourceSet(sourceSet);
        new DslObject((Object)sourceSet).getConvention().add("aspectj", (Object)weavingSourceSet);
        Configuration aspectpath = (Configuration)this.project.getConfigurations().create(weavingSourceSet.getAspectConfigurationName());
        weavingSourceSet.setAspectPath((FileCollection)aspectpath);
        Configuration inpath = (Configuration)this.project.getConfigurations().create(weavingSourceSet.getInpathConfigurationName());
        weavingSourceSet.setInPath((FileCollection)inpath);
        this.project.getConfigurations().getByName(sourceSet.getImplementationConfigurationName()).extendsFrom(new Configuration[]{aspectpath});
        this.project.getConfigurations().getByName(sourceSet.getCompileOnlyConfigurationName()).extendsFrom(new Configuration[]{inpath});
    }

    private void configurePlugin(String language) {
        this.sourceSets.all(sourceSet -> {
            WeavingSourceSet weavingSourceSet = (WeavingSourceSet)new DslObject(sourceSet).getConvention().getByType(WeavingSourceSet.class);
            FileCollection aspectpath = weavingSourceSet.getAspectPath();
            FileCollection inpath = weavingSourceSet.getInPath();
            Configuration runtimeClasspath = this.project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName());
            FileCollection aspectjClasspath = this.aspectjBasePlugin.getAspectjRuntime().inferAspectjClasspath((FileCollection)runtimeClasspath);
            this.project.getTasks().named(sourceSet.getCompileTaskName(language), AbstractCompile.class, compileTask -> {
                AjcAction ajcAction = this.enhanceWithWeavingAction((AbstractCompile)compileTask, aspectpath, inpath, aspectjClasspath);
                if (compileTask instanceof HasCompileOptions) {
                    HasCompileOptions compileTaskWithOptions = (HasCompileOptions)compileTask;
                    ajcAction.getOptions().getBootclasspath().from(new Object[]{compileTaskWithOptions.getOptions().getBootstrapClasspath()});
                    ajcAction.getOptions().getExtdirs().from(new Object[]{compileTaskWithOptions.getOptions().getExtensionDirs()});
                }
            });
        });
    }

    private AjcAction enhanceWithWeavingAction(AbstractCompile abstractCompile, FileCollection aspectpath, FileCollection inpath, FileCollection aspectjConfiguration) {
        AjcAction action = (AjcAction)this.project.getObjects().newInstance(AjcAction.class, new Object[0]);
        action.getOptions().getAspectpath().from(new Object[]{aspectpath});
        action.getOptions().getInpath().from(new Object[]{inpath});
        action.getAdditionalInpath().from(new Object[]{abstractCompile.getDestinationDirectory()});
        action.getClasspath().from(new Object[]{aspectjConfiguration});
        action.addToTask((Task)abstractCompile);
        return action;
    }
}

