/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj;

import io.freefair.gradle.plugins.aspectj.AjcAction;
import io.freefair.gradle.plugins.aspectj.AspectJBasePlugin;
import io.freefair.gradle.plugins.aspectj.internal.DefaultWeavingSourceSet;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.scala.ScalaCompile;

@NonNullApi
public class AspectJPostCompileWeavingPlugin
implements Plugin<Project> {
    private Project project;
    private AspectJBasePlugin aspectjBasePlugin;

    public void apply(Project project) {
        this.project = project;
        this.aspectjBasePlugin = (AspectJBasePlugin)project.getPlugins().apply(AspectJBasePlugin.class);
        project.getPlugins().apply(JavaBasePlugin.class);
        ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(this::configureSourceSet);
    }

    private void configureSourceSet(SourceSet sourceSet) {
        this.project.afterEvaluate(p -> p.getDependencies().add(sourceSet.getImplementationConfigurationName(), (Object)("org.aspectj:aspectjrt:" + (String)this.aspectjBasePlugin.getAspectjExtension().getVersion().get())));
        DefaultWeavingSourceSet weavingSourceSet = new DefaultWeavingSourceSet(sourceSet);
        new DslObject((Object)sourceSet).getConvention().add("aspectj", (Object)weavingSourceSet);
        Configuration aspectpath = (Configuration)this.project.getConfigurations().create(weavingSourceSet.getAspectConfigurationName());
        weavingSourceSet.setAspectPath((FileCollection)aspectpath);
        Configuration inpath = (Configuration)this.project.getConfigurations().create(weavingSourceSet.getInpathConfigurationName());
        weavingSourceSet.setInPath((FileCollection)inpath);
        this.project.getConfigurations().getByName(sourceSet.getImplementationConfigurationName()).extendsFrom(new Configuration[]{aspectpath});
        this.project.getConfigurations().getByName(sourceSet.getCompileOnlyConfigurationName()).extendsFrom(new Configuration[]{inpath});
        this.project.getPlugins().withType(JavaPlugin.class, javaPlugin -> this.project.getTasks().named(sourceSet.getCompileJavaTaskName(), JavaCompile.class, compileJava -> {
            AjcAction ajcAction = this.enhanceWithWeavingAction((AbstractCompile)compileJava, aspectpath, inpath, this.aspectjBasePlugin.getAspectjConfiguration());
            ajcAction.getOptions().getBootclasspath().from(new Object[]{compileJava.getOptions().getBootstrapClasspath()});
            ajcAction.getOptions().getExtdirs().from(new Object[]{compileJava.getOptions().getExtensionDirs()});
        }));
        this.project.getPlugins().withType(GroovyPlugin.class, groovyPlugin -> this.project.getTasks().named(sourceSet.getCompileTaskName("groovy"), GroovyCompile.class, compileGroovy -> {
            AjcAction ajcAction = this.enhanceWithWeavingAction((AbstractCompile)compileGroovy, aspectpath, inpath, this.aspectjBasePlugin.getAspectjConfiguration());
            ajcAction.getOptions().getBootclasspath().from(new Object[]{compileGroovy.getOptions().getBootstrapClasspath()});
            ajcAction.getOptions().getExtdirs().from(new Object[]{compileGroovy.getOptions().getExtensionDirs()});
        }));
        this.project.getPlugins().withType(ScalaBasePlugin.class, scalaBasePlugin -> this.project.getTasks().named(sourceSet.getCompileTaskName("scala"), ScalaCompile.class, compileScala -> {
            AjcAction ajcAction = this.enhanceWithWeavingAction((AbstractCompile)compileScala, aspectpath, inpath, this.aspectjBasePlugin.getAspectjConfiguration());
            ajcAction.getOptions().getBootclasspath().from(new Object[]{compileScala.getOptions().getBootstrapClasspath()});
            ajcAction.getOptions().getExtdirs().from(new Object[]{compileScala.getOptions().getExtensionDirs()});
        }));
        this.project.getPlugins().withId("org.jetbrains.kotlin.jvm", kotlinPlugin -> this.project.getTasks().named(sourceSet.getCompileTaskName("kotlin"), AbstractCompile.class, compileKotlin -> this.enhanceWithWeavingAction((AbstractCompile)compileKotlin, aspectpath, inpath, this.aspectjBasePlugin.getAspectjConfiguration())));
    }

    private AjcAction enhanceWithWeavingAction(AbstractCompile abstractCompile, Configuration aspectpath, Configuration inpath, Configuration aspectjConfiguration) {
        AjcAction action = (AjcAction)this.project.getObjects().newInstance(AjcAction.class, new Object[0]);
        action.getOptions().getAspectpath().from(new Object[]{aspectpath});
        action.getOptions().getInpath().from(new Object[]{inpath});
        action.getAdditionalInpath().from(new Object[]{abstractCompile.getDestinationDir()});
        action.getClasspath().from(new Object[]{aspectjConfiguration});
        action.addToTask((Task)abstractCompile);
        return action;
    }
}

