/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj;

import io.freefair.gradle.plugins.aspectj.AspectJCompileOptions;
import io.freefair.gradle.plugins.aspectj.internal.AspectJCompileSpec;
import io.freefair.gradle.plugins.aspectj.internal.AspectJCompiler;
import java.io.File;
import java.util.ArrayList;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.process.internal.JavaExecHandleFactory;

@NonNullApi
public class AjcAction
implements Action<Task> {
    private final ConfigurableFileCollection classpath;
    private final Property<Boolean> enabled;
    private final AspectJCompileOptions options;
    private final JavaExecHandleFactory javaExecHandleFactory;

    public void options(Action<AspectJCompileOptions> action) {
        action.execute((Object)this.getOptions());
    }

    @Inject
    public AjcAction(ObjectFactory objectFactory, JavaExecHandleFactory javaExecHandleFactory) {
        this.options = new AspectJCompileOptions(objectFactory);
        this.classpath = objectFactory.fileCollection();
        this.enabled = objectFactory.property(Boolean.class).convention((Object)true);
        this.javaExecHandleFactory = javaExecHandleFactory;
    }

    public void addToTask(Task task) {
        task.doLast("ajc", (Action)this);
        task.getExtensions().add("ajc", (Object)this);
        task.getInputs().files(new Object[]{this.getClasspath()}).withPropertyName("aspectjClasspath").withNormalizer(ClasspathNormalizer.class).optional(false);
        task.getInputs().files(new Object[]{this.getOptions().getAspectpath()}).withPropertyName("aspectpath").withNormalizer(ClasspathNormalizer.class).optional(true);
        task.getInputs().files(new Object[]{this.getOptions().getInpath()}).withPropertyName("ajcInpath").withNormalizer(ClasspathNormalizer.class).optional(true);
        task.getInputs().property("ajcArgs", this.getOptions().getCompilerArgs()).optional(true);
        task.getInputs().property("ajcEnabled", this.getEnabled()).optional(true);
    }

    public void execute(Task task) {
        if (!((Boolean)this.enabled.getOrElse((Object)true)).booleanValue()) {
            return;
        }
        AspectJCompileSpec spec = this.createSpec((AbstractCompile)task);
        new AspectJCompiler(this.javaExecHandleFactory).execute(spec);
    }

    private AspectJCompileSpec createSpec(AbstractCompile compile) {
        AspectJCompileSpec spec = new AspectJCompileSpec();
        spec.setDestinationDir(compile.getDestinationDir());
        spec.setWorkingDir(compile.getProject().getProjectDir());
        spec.setTempDir(compile.getTemporaryDir());
        spec.setCompileClasspath(new ArrayList(compile.getClasspath().filter(File::exists).getFiles()));
        spec.setTargetCompatibility(compile.getTargetCompatibility());
        spec.setSourceCompatibility(compile.getSourceCompatibility());
        spec.setAspectJClasspath((FileCollection)this.getClasspath());
        spec.setAspectJCompileOptions(this.getOptions());
        return spec;
    }

    @Generated
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @Generated
    public Property<Boolean> getEnabled() {
        return this.enabled;
    }

    @Generated
    public AspectJCompileOptions getOptions() {
        return this.options;
    }
}

