/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj;

import io.freefair.gradle.plugins.aspectj.AspectJBasePlugin;
import io.freefair.gradle.plugins.aspectj.AspectjCompile;
import io.freefair.gradle.plugins.aspectj.internal.DefaultAspectjSourceSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.SourceSetUtil;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;

public class AspectJPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(AspectJBasePlugin.class);
        project.getPlugins().apply(JavaBasePlugin.class);
        JavaPluginConvention plugin = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        plugin.getSourceSets().all(sourceSet -> {
            DefaultAspectjSourceSet aspectjSourceSet = new DefaultAspectjSourceSet(project.getObjects(), (SourceSet)sourceSet);
            new DslObject(sourceSet).getConvention().getPlugins().put("aspectj", aspectjSourceSet);
            aspectjSourceSet.getAspectj().srcDir((Object)("src/" + sourceSet.getName() + "/aspectj"));
            sourceSet.getResources().getFilter().exclude(element -> aspectjSourceSet.getAspectj().contains(element.getFile()));
            sourceSet.getAllJava().source(aspectjSourceSet.getAspectj());
            sourceSet.getAllSource().source(aspectjSourceSet.getAspectj());
            Configuration aspect = (Configuration)project.getConfigurations().create(aspectjSourceSet.getAspectConfigurationName());
            aspectjSourceSet.setAspectPath((FileCollection)aspect);
            Configuration inpath = (Configuration)project.getConfigurations().create(aspectjSourceSet.getInpathConfigurationName());
            aspectjSourceSet.setInPath((FileCollection)inpath);
            project.getConfigurations().getByName(sourceSet.getCompileConfigurationName()).extendsFrom(new Configuration[]{aspect});
            project.getConfigurations().getByName(sourceSet.getCompileOnlyConfigurationName()).extendsFrom(new Configuration[]{inpath});
            TaskProvider compileTask = project.getTasks().register(sourceSet.getCompileTaskName("aspectj"), AspectjCompile.class, compile -> {
                SourceSetUtil.configureForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)aspectjSourceSet.getAspectj(), (AbstractCompile)compile, (CompileOptions)compile.getOptions(), (Project)project);
                compile.dependsOn(new Object[]{sourceSet.getCompileJavaTaskName()});
                compile.setDescription("Compiles the " + sourceSet.getName() + " AspectJ source.");
                compile.setSource((FileTree)aspectjSourceSet.getAspectj());
                compile.getAjcOptions().getAspectpath().from(new Object[]{aspect});
                compile.getAjcOptions().getInpath().from(new Object[]{inpath});
            });
            SourceSetUtil.configureOutputDirectoryForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)aspectjSourceSet.getAspectj(), (Project)project, (Provider)compileTask, (Provider)compileTask.map(AspectjCompile::getOptions));
            project.getTasks().named(sourceSet.getClassesTaskName(), arg_0 -> AspectJPlugin.lambda$apply$2((Provider)compileTask, arg_0));
        });
    }

    private static /* synthetic */ void lambda$apply$2(Provider compileTask, Task task) {
        task.dependsOn(new Object[]{compileTask});
    }
}

